import cx from 'classnames';
import React from 'react';
import Hint from '../Hint';
import Input from '../Input';
import { isSelectable, propsWithBsClassName } from '../../utils';
function TypeaheadInputMulti(props) {
    const wrapperRef = React.useRef(null);
    const inputElem = React.useRef(null);
    const { children, className, inputClassName, inputRef, referenceElementRef, selected, ...rest } = propsWithBsClassName(props);
    function getInputRef(input) {
        inputElem.current = input;
        props.inputRef(input);
    }
    function handleContainerClickOrFocus(e) {
        if (props.disabled) {
            e.currentTarget.blur();
            return;
        }
        const inputNode = inputElem.current;
        if (!inputNode ||
            (e.currentTarget.contains(e.target) &&
                e.currentTarget !== e.target)) {
            return;
        }
        if (isSelectable(inputNode)) {
            inputNode.selectionStart = inputNode.value.length;
        }
        inputNode.focus();
    }
    function handleKeyDown(e) {
        if (e.key === 'Backspace' && selected.length && !props.value) {
            e.preventDefault();
            const wrapperChildren = wrapperRef.current?.children;
            if (wrapperChildren?.length) {
                const lastToken = wrapperChildren[wrapperChildren.length - 2];
                lastToken?.focus();
            }
        }
        props.onKeyDown && props.onKeyDown(e);
    }
    return (React.createElement("div", { className: cx('rbt-input-multi', { disabled: props.disabled }, className), onClick: handleContainerClickOrFocus, onFocus: handleContainerClickOrFocus, ref: referenceElementRef, tabIndex: -1 },
        React.createElement("div", { className: "rbt-input-wrapper", ref: wrapperRef },
            children,
            React.createElement(Hint, null,
                React.createElement(Input, { ...rest, className: inputClassName, onKeyDown: handleKeyDown, ref: getInputRef, style: {
                        backgroundColor: 'transparent',
                        border: 0,
                        boxShadow: 'none',
                        cursor: 'inherit',
                        outline: 'none',
                        padding: 0,
                        width: '100%',
                        zIndex: 1,
                    } })))));
}
export default TypeaheadInputMulti;
