"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classnames = _interopRequireDefault(require("classnames"));
var _getMenuItemId = _interopRequireDefault(require("./getMenuItemId"));
var _hasOwnProperty = _interopRequireDefault(require("./hasOwnProperty"));
var _excluded = ["activeIndex", "id", "isFocused", "isMenuShown", "multiple", "onClick", "onFocus", "placeholder"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2["default"])(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var getInputProps = function getInputProps(_ref) {
  var activeIndex = _ref.activeIndex,
    id = _ref.id,
    isFocused = _ref.isFocused,
    isMenuShown = _ref.isMenuShown,
    multiple = _ref.multiple,
    onClick = _ref.onClick,
    onFocus = _ref.onFocus,
    placeholder = _ref.placeholder,
    props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  return function () {
    var _cx;
    var inputProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var className = (0, _hasOwnProperty["default"])(inputProps, 'className') ? String(inputProps.className) : undefined;
    return _objectSpread(_objectSpread(_objectSpread(_objectSpread({
      // These props can be overridden by values in `inputProps`.
      autoComplete: 'off',
      placeholder: placeholder,
      type: 'text'
    }, inputProps), props), {}, {
      'aria-activedescendant': activeIndex >= 0 ? (0, _getMenuItemId["default"])(id, activeIndex) : undefined,
      'aria-autocomplete': 'both',
      'aria-expanded': isMenuShown,
      'aria-haspopup': 'listbox',
      'aria-multiselectable': multiple || undefined,
      'aria-owns': isMenuShown ? id : undefined,
      className: (0, _classnames["default"])((_cx = {}, (0, _defineProperty2["default"])(_cx, className || '', !multiple), (0, _defineProperty2["default"])(_cx, "focus", isFocused), _cx))
    }, multiple && {
      inputClassName: className
    }), {}, {
      onClick: onClick,
      onFocus: onFocus,
      role: 'combobox'
    });
  };
};
var _default = exports["default"] = getInputProps;