import { FnType } from '../types/FnType';
import { IEventHandler } from '../types/IEventHandler';
/**
 * Creates a debounced function that delays invoking func until
 * after delay milliseconds has elapsed since the last time the
 * debounced function was invoked.
 *
 * @param fn  Function to debounce
 * @param delay  How long to wait
 * @return Executed Function
 * @private
 **/
export declare function debounceFn(fn: FnType, delay: number): IEventHandler;
