import cx from 'classnames';
import PropTypes from 'prop-types';
import React, { Children } from 'react';
import { BaseMenuItem } from '../MenuItem';
import { preventInputBlur } from '../../utils';
import { checkPropType, isRequiredForA11y } from '../../propTypes';
const MenuDivider = () => React.createElement("div", { className: "dropdown-divider", role: "separator" });
const MenuHeader = (props) => (React.createElement("div", { ...props, className: "dropdown-header", role: "heading" }));
const propTypes = {
    'aria-label': PropTypes.string,
    emptyLabel: PropTypes.node,
    id: checkPropType(PropTypes.oneOfType([PropTypes.number, PropTypes.string]), isRequiredForA11y),
    maxHeight: PropTypes.string,
};
const Menu = ({ emptyLabel = 'No matches found.', innerRef, maxHeight = '300px', style, ...props }) => {
    const children = Children.count(props.children) === 0 ? (React.createElement(BaseMenuItem, { disabled: true, role: "option" }, emptyLabel)) : (props.children);
    return (React.createElement("div", { ...props, "aria-label": props['aria-label'] || 'menu-options', className: cx('rbt-menu', 'dropdown-menu', 'show', props.className), onMouseDown: preventInputBlur, ref: innerRef, role: "listbox", style: {
            ...style,
            display: 'block',
            maxHeight,
            overflow: 'auto',
        } }, children));
};
Menu.propTypes = propTypes;
Menu.Divider = MenuDivider;
Menu.Header = MenuHeader;
export default Menu;
