"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _ProfileConfiguration = _interopRequireDefault(require("./ProfileConfiguration"));
var _SAMLMetadata = _interopRequireDefault(require("./SAMLMetadata"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
 * The TrustRelationship model module.
 * @module model/TrustRelationship
 * @version OAS Version
 */
var TrustRelationship = /*#__PURE__*/function () {
  /**
   * Constructs a new <code>TrustRelationship</code>.
   * @alias module:model/TrustRelationship
   * @param name {String} The alphanumeric ID string that is used to identify the Trust Relationship.
   * @param displayName {String} Trust Relationship display name.
   * @param description {String} Description of the Trust Relationship.
   * @param spMetaDataSourceType {module:model/TrustRelationship.SpMetaDataSourceTypeEnum} Trust Relationship SP metadata type - file, URI.
   */
  function TrustRelationship(name, displayName, description, spMetaDataSourceType) {
    _classCallCheck(this, TrustRelationship);
    TrustRelationship.initialize(this, name, displayName, description, spMetaDataSourceType);
  }

  /**
   * Initializes the fields of this object.
   * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
   * Only for internal use.
   */
  return _createClass(TrustRelationship, null, [{
    key: "initialize",
    value: function initialize(obj, name, displayName, description, spMetaDataSourceType) {
      obj['name'] = name;
      obj['displayName'] = displayName;
      obj['description'] = description;
      obj['spMetaDataSourceType'] = spMetaDataSourceType;
    }

    /**
     * Constructs a <code>TrustRelationship</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/TrustRelationship} obj Optional instance to populate.
     * @return {module:model/TrustRelationship} The populated <code>TrustRelationship</code> instance.
     */
  }, {
    key: "constructFromObject",
    value: function constructFromObject(data, obj) {
      if (data) {
        obj = obj || new TrustRelationship();
        if (data.hasOwnProperty('dn')) {
          obj['dn'] = _ApiClient["default"].convertToType(data['dn'], 'String');
        }
        if (data.hasOwnProperty('inum')) {
          obj['inum'] = _ApiClient["default"].convertToType(data['inum'], 'String');
        }
        if (data.hasOwnProperty('owner')) {
          obj['owner'] = _ApiClient["default"].convertToType(data['owner'], 'String');
        }
        if (data.hasOwnProperty('name')) {
          obj['name'] = _ApiClient["default"].convertToType(data['name'], 'String');
        }
        if (data.hasOwnProperty('displayName')) {
          obj['displayName'] = _ApiClient["default"].convertToType(data['displayName'], 'String');
        }
        if (data.hasOwnProperty('description')) {
          obj['description'] = _ApiClient["default"].convertToType(data['description'], 'String');
        }
        if (data.hasOwnProperty('baseUrl')) {
          obj['baseUrl'] = _ApiClient["default"].convertToType(data['baseUrl'], 'String');
        }
        if (data.hasOwnProperty('enabled')) {
          obj['enabled'] = _ApiClient["default"].convertToType(data['enabled'], 'Boolean');
        }
        if (data.hasOwnProperty('alwaysDisplayInConsole')) {
          obj['alwaysDisplayInConsole'] = _ApiClient["default"].convertToType(data['alwaysDisplayInConsole'], 'Boolean');
        }
        if (data.hasOwnProperty('clientAuthenticatorType')) {
          obj['clientAuthenticatorType'] = _ApiClient["default"].convertToType(data['clientAuthenticatorType'], 'String');
        }
        if (data.hasOwnProperty('secret')) {
          obj['secret'] = _ApiClient["default"].convertToType(data['secret'], 'String');
        }
        if (data.hasOwnProperty('registrationAccessToken')) {
          obj['registrationAccessToken'] = _ApiClient["default"].convertToType(data['registrationAccessToken'], 'String');
        }
        if (data.hasOwnProperty('consentRequired')) {
          obj['consentRequired'] = _ApiClient["default"].convertToType(data['consentRequired'], 'Boolean');
        }
        if (data.hasOwnProperty('spMetaDataSourceType')) {
          obj['spMetaDataSourceType'] = _ApiClient["default"].convertToType(data['spMetaDataSourceType'], 'String');
        }
        if (data.hasOwnProperty('samlMetadata')) {
          obj['samlMetadata'] = _SAMLMetadata["default"].constructFromObject(data['samlMetadata']);
        }
        if (data.hasOwnProperty('redirectUris')) {
          obj['redirectUris'] = _ApiClient["default"].convertToType(data['redirectUris'], ['String']);
        }
        if (data.hasOwnProperty('spMetaDataURL')) {
          obj['spMetaDataURL'] = _ApiClient["default"].convertToType(data['spMetaDataURL'], 'String');
        }
        if (data.hasOwnProperty('metaLocation')) {
          obj['metaLocation'] = _ApiClient["default"].convertToType(data['metaLocation'], 'String');
        }
        if (data.hasOwnProperty('releasedAttributes')) {
          obj['releasedAttributes'] = _ApiClient["default"].convertToType(data['releasedAttributes'], ['String']);
        }
        if (data.hasOwnProperty('spLogoutURL')) {
          obj['spLogoutURL'] = _ApiClient["default"].convertToType(data['spLogoutURL'], 'String');
        }
        if (data.hasOwnProperty('status')) {
          obj['status'] = _ApiClient["default"].convertToType(data['status'], 'String');
        }
        if (data.hasOwnProperty('validationStatus')) {
          obj['validationStatus'] = _ApiClient["default"].convertToType(data['validationStatus'], 'String');
        }
        if (data.hasOwnProperty('validationLog')) {
          obj['validationLog'] = _ApiClient["default"].convertToType(data['validationLog'], ['String']);
        }
        if (data.hasOwnProperty('profileConfigurations')) {
          obj['profileConfigurations'] = _ApiClient["default"].convertToType(data['profileConfigurations'], {
            'String': _ProfileConfiguration["default"]
          });
        }
        if (data.hasOwnProperty('baseDn')) {
          obj['baseDn'] = _ApiClient["default"].convertToType(data['baseDn'], 'String');
        }
      }
      return obj;
    }
  }]);
}();
/**
 * @member {String} dn
 */
TrustRelationship.prototype['dn'] = undefined;

/**
 * Unique identifier
 * @member {String} inum
 */
TrustRelationship.prototype['inum'] = undefined;

/**
 * Creator of Trust Relationship.
 * @member {String} owner
 */
TrustRelationship.prototype['owner'] = undefined;

/**
 * The alphanumeric ID string that is used to identify the Trust Relationship.
 * @member {String} name
 */
TrustRelationship.prototype['name'] = undefined;

/**
 * Trust Relationship display name.
 * @member {String} displayName
 */
TrustRelationship.prototype['displayName'] = undefined;

/**
 * Description of the Trust Relationship.
 * @member {String} description
 */
TrustRelationship.prototype['description'] = undefined;

/**
 * URL to use when the auth server needs to redirect.
 * @member {String} baseUrl
 */
TrustRelationship.prototype['baseUrl'] = undefined;

/**
 * Indicates if Trust Relationship is enabled.
 * @member {Boolean} enabled
 */
TrustRelationship.prototype['enabled'] = undefined;

/**
 * Indicates if Trust Relationship should always be listed in the UI.
 * @member {Boolean} alwaysDisplayInConsole
 */
TrustRelationship.prototype['alwaysDisplayInConsole'] = undefined;

/**
 * Preferred Authenticator Type.
 * @member {String} clientAuthenticatorType
 */
TrustRelationship.prototype['clientAuthenticatorType'] = undefined;

/**
 * Client secret.
 * @member {String} secret
 */
TrustRelationship.prototype['secret'] = undefined;

/**
 * Registration access token.
 * @member {String} registrationAccessToken
 */
TrustRelationship.prototype['registrationAccessToken'] = undefined;

/**
 * Boolean value if consent is required.
 * @member {Boolean} consentRequired
 */
TrustRelationship.prototype['consentRequired'] = undefined;

/**
 * Trust Relationship SP metadata type - file, URI.
 * @member {module:model/TrustRelationship.SpMetaDataSourceTypeEnum} spMetaDataSourceType
 */
TrustRelationship.prototype['spMetaDataSourceType'] = undefined;

/**
 * @member {module:model/SAMLMetadata} samlMetadata
 */
TrustRelationship.prototype['samlMetadata'] = undefined;

/**
 * List of valid Redirect URI.
 * @member {Array.<String>} redirectUris
 */
TrustRelationship.prototype['redirectUris'] = undefined;

/**
 * SAML entity metadata file URL.
 * @member {String} spMetaDataURL
 */
TrustRelationship.prototype['spMetaDataURL'] = undefined;

/**
 * Trust Relationship metadata file location.
 * @member {String} metaLocation
 */
TrustRelationship.prototype['metaLocation'] = undefined;

/**
 * Trust Relationship attributes that will be released to SAML server.
 * @member {Array.<String>} releasedAttributes
 */
TrustRelationship.prototype['releasedAttributes'] = undefined;

/**
 * Logout request URL.
 * @member {String} spLogoutURL
 */
TrustRelationship.prototype['spLogoutURL'] = undefined;

/**
 * Trust Relationship setup status.
 * @member {module:model/TrustRelationship.StatusEnum} status
 */
TrustRelationship.prototype['status'] = undefined;

/**
 * Trust Relationship validation status.
 * @member {module:model/TrustRelationship.ValidationStatusEnum} validationStatus
 */
TrustRelationship.prototype['validationStatus'] = undefined;

/**
 * Validation log.
 * @member {Array.<String>} validationLog
 */
TrustRelationship.prototype['validationLog'] = undefined;

/**
 * List of profile configuration.
 * @member {Object.<String, module:model/ProfileConfiguration>} profileConfigurations
 */
TrustRelationship.prototype['profileConfigurations'] = undefined;

/**
 * @member {String} baseDn
 */
TrustRelationship.prototype['baseDn'] = undefined;

/**
 * Allowed values for the <code>spMetaDataSourceType</code> property.
 * @enum {String}
 * @readonly
 */
TrustRelationship['SpMetaDataSourceTypeEnum'] = {
  /**
   * value: "file"
   * @const
   */
  "file": "file",
  /**
   * value: "manual"
   * @const
   */
  "manual": "manual"
};

/**
 * Allowed values for the <code>status</code> property.
 * @enum {String}
 * @readonly
 */
TrustRelationship['StatusEnum'] = {
  /**
   * value: "active"
   * @const
   */
  "active": "active",
  /**
   * value: "inactive"
   * @const
   */
  "inactive": "inactive",
  /**
   * value: "expired"
   * @const
   */
  "expired": "expired",
  /**
   * value: "register"
   * @const
   */
  "register": "register"
};

/**
 * Allowed values for the <code>validationStatus</code> property.
 * @enum {String}
 * @readonly
 */
TrustRelationship['ValidationStatusEnum'] = {
  /**
   * value: "In Progress"
   * @const
   */
  "In Progress": "In Progress",
  /**
   * value: "Success"
   * @const
   */
  "Success": "Success",
  /**
   * value: "Scheduled"
   * @const
   */
  "Scheduled": "Scheduled",
  /**
   * value: "Failed"
   * @const
   */
  "Failed": "Failed"
};
var _default = exports["default"] = TrustRelationship;