/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;

public class XmlTransformer
extends DirectoryWalker<File> {
    private Transformer transformer;

    public XmlTransformer(FileFilter filterToMatch, String xslResource) {
        super(filterToMatch, -1);
        try {
            this.transformer = this.getTransformer(xslResource);
        }
        catch (IOException ie) {
            System.err.println(Arrays.toString(ie.getStackTrace()));
            System.exit(1);
        }
        catch (TransformerConfigurationException tce) {
            System.err.println(Arrays.toString(tce.getStackTrace()));
            System.exit(1);
        }
    }

    public XmlTransformer(String xsl, FileFilter filterToMatch) {
        super(filterToMatch, -1);
        try {
            this.transformer = this.getTransformerForString(xsl);
        }
        catch (TransformerConfigurationException tce) {
            System.err.println(Arrays.toString(tce.getStackTrace()));
            System.exit(1);
        }
    }

    private Transformer getTransformer(String xslResource) throws IOException, TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslt = new StreamSource(((Object)((Object)this)).getClass().getResource(xslResource).openStream());
        return factory.newTransformer(xslt);
    }

    private Transformer getTransformerForString(String xsl) throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslt = new StreamSource(new ByteArrayInputStream(xsl.getBytes(Charset.forName("UTF-8"))));
        return factory.newTransformer(xslt);
    }

    public final List<File> update(File startDirectory) throws IOException {
        ArrayList<File> results = new ArrayList<File>();
        this.walk(startDirectory, results);
        return results;
    }

    protected final void handleFile(File file, int depth, Collection<File> results) throws IOException {
        if (file.isFile()) {
            try {
                StreamSource xml = new StreamSource(file);
                File tmpFile = File.createTempFile(file.getName(), ".tmp");
                this.transformer.transform(xml, new StreamResult(tmpFile));
                FileUtils.deleteQuietly((File)file);
                FileUtils.moveFile((File)tmpFile, (File)file);
                results.add(file);
            }
            catch (TransformerException te) {
                throw new IOException(file.toString() + te.getMessageAndLocation(), te);
            }
        }
    }
}

