/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;

public final class SyntaxHighlighterCopier {
    private final String[] shCssResources = new String[]{"/css/shCore.css", "/css/shCoreEclipse.css", "/css/shThemeEclipse.css"};
    private final String[] shJavaScriptResources = new String[]{"/js/shCore.js", "/js/shBrushAci.js", "/js/shBrushBash.js", "/js/shBrushCsv.js", "/js/shBrushHttp.js", "/js/shBrushJava.js", "/js/shBrushJScript.js", "/js/shBrushLDIF.js", "/js/shBrushPlain.js", "/js/shBrushProperties.js", "/js/shBrushXml.js", "/js/shAll.js"};
    private String[] outputDirectories;

    public SyntaxHighlighterCopier(String[] outputDirectories) {
        this.outputDirectories = outputDirectories;
    }

    public void copy() throws IOException {
        this.addShCss();
        this.addShScripts();
    }

    private void addShCss() throws IOException {
        this.addShResources(this.shCssResources);
    }

    private void addShScripts() throws IOException {
        this.addShResources(this.shJavaScriptResources);
    }

    private void addShResources(String[] resources) throws IOException {
        for (String resource : resources) {
            URL resourceUrl = this.getClass().getResource(resource);
            for (String outputDirectory : this.outputDirectories) {
                File styleSheetFile = FileUtils.getFile((String[])new String[]{outputDirectory, "sh", resource});
                FileUtils.copyURLToFile((URL)resourceUrl, (File)styleSheetFile);
            }
        }
    }
}

