/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Map;
import org.forgerock.doc.maven.utils.XmlTransformer;
import org.forgerock.doc.maven.utils.helper.FileFilterFactory;

public class Profiler {
    private final Map<String, String> inclusions;
    private final Map<String, String> exclusions;

    public Profiler(Map<String, String> inclusions, Map<String, String> exclusions) {
        this.inclusions = inclusions;
        this.exclusions = exclusions;
    }

    public void applyProfiles(File xmlSourceDirectory) throws IOException {
        if (this.inclusions == null && this.exclusions == null) {
            return;
        }
        FileFilter fileFilter = FileFilterFactory.getXmlFileFilter();
        Transformer transformer = new Transformer(this.getXsl(), fileFilter);
        transformer.update(xmlSourceDirectory);
    }

    private String getXsl() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>\n").append("<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n").append("  <xsl:template match=\"node()|@*\">\n").append("    <xsl:copy>\n").append("      <xsl:apply-templates select=\"node()|@*\"/>\n").append("    </xsl:copy>\n").append("  </xsl:template>\n");
        if (this.inclusions != null) {
            for (String attribute : this.inclusions.keySet()) {
                sb.append("<xsl:template match=\"//*[").append(this.getInclusionsMatch(attribute, this.inclusions.get(attribute).split("\\s+"))).append("]\"/>\n");
            }
        }
        if (this.exclusions != null) {
            for (String attribute : this.exclusions.keySet()) {
                sb.append("<xsl:template match=\"//*[").append(this.getExclusionsMatch(attribute, this.exclusions.get(attribute).split("\\s+"))).append("]\"/>\n");
            }
        }
        sb.append("</xsl:stylesheet>\n");
        return sb.toString();
    }

    private String getInclusionsMatch(String attribute, String[] values) {
        if (attribute == null || attribute.isEmpty()) {
            return "";
        }
        if (values == null || values.length == 0) {
            return "";
        }
        if (values.length == 1) {
            return "@" + attribute + " != '" + values[0] + "'";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = values.length - 1; i > 0; --i) {
            sb.append("@").append(attribute).append(" != '").append(values[i]).append("' and ");
        }
        sb.append("@").append(attribute).append(" != '").append(values[0]).append("'");
        return sb.toString();
    }

    private String getExclusionsMatch(String attribute, String[] values) {
        if (attribute == null || attribute.isEmpty()) {
            return "";
        }
        if (values == null || values.length == 0) {
            return "";
        }
        if (values.length == 1) {
            return "@" + attribute + " = '" + values[0] + "'";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = values.length - 1; i > 0; --i) {
            sb.append("@").append(attribute).append(" = '").append(values[i]).append("' or ");
        }
        sb.append("@").append(attribute).append(" = '").append(values[0]).append("'");
        return sb.toString();
    }

    private class Transformer
    extends XmlTransformer {
        public Transformer(String xsl, FileFilter filterToMatch) {
            super(xsl, filterToMatch);
        }
    }
}

