/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.utils;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.io.FileUtils;

public final class PngUtils {
    private static int getHeight(File image) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(image);
        return bufferedImage.getHeight();
    }

    private static int getWidth(File image) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(image);
        return bufferedImage.getWidth();
    }

    public static void resizePng(File image) throws IOException {
        BufferedImage originalImage = ImageIO.read(image);
        int imageWidth = PngUtils.getWidth(image);
        int imageHeight = PngUtils.getHeight(image);
        int newWidth = 700;
        String absolutePath = image.getAbsolutePath();
        File thumbFile = new File(image.getParent(), "thumb_" + image.getName());
        if (imageWidth > 700) {
            int newHeight = Math.round(imageHeight * 700 / imageWidth);
            BufferedImage scaledBI = PngUtils.getScaledInstance(originalImage, 700, newHeight, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
            PngUtils.saveBufferedImage(scaledBI, thumbFile, 160);
        } else {
            PngUtils.saveBufferedImage(originalImage, thumbFile, 160);
        }
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    public static void setSafeDpi(File image, int maxHeightInInches) throws IOException {
        int imageHeight = PngUtils.getHeight(image);
        int defaultDpi = 160;
        int defaultMaxHeight = maxHeightInInches * 160;
        if (imageHeight > defaultMaxHeight) {
            double dpi = (double)imageHeight * 1.0 / (double)maxHeightInInches;
            PngUtils.setDpi(image, (int)Math.round(dpi));
        } else {
            PngUtils.setDpi(image);
        }
    }

    public static void setDpi(File image) throws IOException {
        PngUtils.setDpi(image, 160);
    }

    public static void setDpi(File image, int dotsPerInch) throws IOException {
        BufferedImage in = ImageIO.read(image);
        File updatedImage = File.createTempFile(image.getName(), ".tmp");
        PngUtils.saveBufferedImage(in, updatedImage, dotsPerInch);
        FileUtils.deleteQuietly((File)image);
        FileUtils.moveFile((File)updatedImage, (File)image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveBufferedImage(BufferedImage bufferedImage, File outputFile, int dotsPerInch) throws IOException {
        Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName("png");
        while (iw.hasNext()) {
            ImageWriter writer = iw.next();
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
            IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
            PngUtils.setDpi(metadata, dotsPerInch);
            try (ImageOutputStream stream = ImageIO.createImageOutputStream(outputFile);){
                writer.setOutput(stream);
                writer.write(metadata, new IIOImage(bufferedImage, null, metadata), writeParam);
                break;
            }
        }
    }

    private static void setDpi(IIOMetadata metadata, int dotsPerInch) throws IIOInvalidTreeException {
        double inchesPerMillimeter = 0.03937007874015748;
        double dotsPerMillimeter = (double)dotsPerInch * 0.03937007874015748;
        IIOMetadataNode horizontalPixelSize = new IIOMetadataNode("HorizontalPixelSize");
        horizontalPixelSize.setAttribute("value", Double.toString(dotsPerMillimeter));
        IIOMetadataNode verticalPixelSize = new IIOMetadataNode("VerticalPixelSize");
        verticalPixelSize.setAttribute("value", Double.toString(dotsPerMillimeter));
        IIOMetadataNode dimension = new IIOMetadataNode("Dimension");
        dimension.appendChild(horizontalPixelSize);
        dimension.appendChild(verticalPixelSize);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dimension);
        metadata.mergeTree("javax_imageio_1.0", root);
    }

    private PngUtils() {
    }
}

