/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.utils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.utils.helper.NameMethod;

public final class OLinkUtils {
    private static Configuration configuration;

    public static void createTargetDatabase(File file, String format, AbstractDocbkxMojo mojo) throws IOException, MojoExecutionException {
        OLinkUtils.createTargetDatabase(file, format, mojo, false);
    }

    public static void createTargetDatabase(File file, String format, AbstractDocbkxMojo mojo, boolean isChunkedHtml) throws IOException, MojoExecutionException {
        OLinkUtils.createTargetDatabase(file, mojo.getBuildDirectory().getAbsolutePath(), mojo.getDocNames(), FilenameUtils.getBaseName((String)mojo.getDocumentSrcName()), format, isChunkedHtml, mojo.getProjectName(), mojo.getProjectVersion());
    }

    private static void createTargetDatabase(File file, String basePath, Set<String> docNames, String documentSrcName, String format, boolean isChunked, String projectName, String projectVersion) throws IOException {
        Configuration configuration = OLinkUtils.getConfiguration();
        Map<String, Object> map = OLinkUtils.getModel(basePath, docNames, documentSrcName, format, isChunked, projectName, projectVersion);
        Template template = configuration.getTemplate("olinkdb.ftl");
        FileOutputStream out = FileUtils.openOutputStream((File)file);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            template.process(map, (Writer)writer);
        }
        catch (TemplateException e) {
            throw new IOException("Failed to write template", e);
        }
        finally {
            ((Writer)writer).close();
            out.close();
        }
    }

    private static Configuration getConfiguration() {
        if (configuration != null) {
            return configuration;
        }
        configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        configuration.setClassForTemplateLoading(OLinkUtils.class, "/templates");
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.DEBUG_HANDLER);
        return configuration;
    }

    private static Map<String, Object> getModel(String basePath, Set<String> docNames, String documentSrcName, String format, boolean isChunked, String projectName, String projectVersion) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("baseName", documentSrcName);
        map.put("basePath", basePath);
        ArrayList<String> docs = new ArrayList<String>(docNames.size());
        docs.addAll(docNames);
        map.put("docNames", docs);
        String extension = format;
        if (format.equals("xhtml5")) {
            format = "xhtml";
            extension = "xhtml";
        }
        if (format.equals("bootstrap")) {
            extension = "html";
        }
        map.put("extension", extension);
        map.put("format", format);
        map.put("isChunked", isChunked);
        map.put("name", new NameMethod());
        map.put("projectName", projectName);
        map.put("projectVersion", projectVersion);
        String type = format;
        if (format.equals("pdf") || format.equals("rtf")) {
            type = "fo";
        }
        if (format.equals("xhtml")) {
            type = "xhtml";
        }
        if (format.equals("bootstrap")) {
            type = "html";
        }
        map.put("type", type);
        return map;
    }

    private OLinkUtils() {
    }
}

