/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.plexus.util.StringUtils;

public final class NameUtils {
    @Deprecated
    public static final Pattern DOCUMENT_FILE_PATTERN = Pattern.compile("^([a-zA-Z0-9]+)(-?[0-9].[0-9\\.]*[0-9])?(-SNAPSHOT|(-Ex|-ex|-X)press[0-9])?([a-zA-Z-]*)((-?[0-9].[0-9\\.]*[0-9])?-?(SNAPSHOT|(Ex|ex|X)press[0-9]?)?)$");

    public static String renameDoc(String projectName, String docName, String extension) {
        return NameUtils.renameDoc(projectName, docName, "", extension);
    }

    public static String renameDoc(String projectName, String docName, String version, String extension) {
        if (!StringUtils.isNotBlank((String)docName)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)projectName)) {
            sb.append(NameUtils.spacesToHyphens(NameUtils.capitalize(projectName))).append('-');
            if (StringUtils.isNotBlank((String)version)) {
                sb.append(version).append('-');
            }
        }
        sb.append(NameUtils.capitalize(docName));
        if (StringUtils.isNotBlank((String)extension)) {
            sb.append('.').append(extension);
        }
        return sb.toString();
    }

    protected static String capitalize(String docName) {
        char[] chars = docName.toCharArray();
        boolean isInitial = true;
        for (int i = 0; i < chars.length; ++i) {
            if (isInitial && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                isInitial = false;
                continue;
            }
            isInitial = !Character.isLetter(chars[i]);
        }
        return String.valueOf(chars);
    }

    protected static String spacesToHyphens(String string) {
        return string.replaceAll(" ", "-");
    }

    public static Set<String> getDocumentNames(File srcDir, final String docFile) {
        TreeSet<String> documentDirectories = new TreeSet<String>();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] directories = srcDir.listFiles(filter);
        if (directories != null && directories.length > 0) {
            FilenameFilter nameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String name) {
                    return name.equalsIgnoreCase(docFile);
                }
            };
            for (File dir : directories) {
                String[] found = dir.list(nameFilter);
                if (found.length <= 0) continue;
                documentDirectories.add(dir.getName());
            }
        }
        return documentDirectories;
    }

    public static void renameDocument(File builtDocument, String docName, String projectName) throws IOException {
        String ext = FilenameUtils.getExtension((String)builtDocument.getName());
        File newFile = new File(builtDocument.getParent(), NameUtils.renameDoc(projectName, docName, ext));
        if (!newFile.exists()) {
            FileUtils.moveFile((File)builtDocument, (File)newFile);
        }
    }

    private NameUtils() {
    }
}

