/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.utils.NameUtils;

public final class ImageCopier {
    private static final String[] IMAGE_FILE_SUFFIXES = new String[]{".bmp", ".eps", ".gif", ".jpeg", ".jpg", ".png", ".svg", ".tiff"};

    public static void copyImages(String docType, String baseName, AbstractDocbkxMojo mojo) throws IOException {
        ImageCopier.copyImages(docType, baseName, mojo.getDocumentSrcName(), mojo.getDocbkxModifiableSourcesDirectory(), mojo.getDocbkxOutputDirectory());
    }

    public static void copyImages(String docType, String baseName, String documentSrcName, File sourceDirectory, File outputDirectory) throws IOException {
        if (docType == null) {
            throw new IllegalArgumentException("Type of output document must not be null.");
        }
        if (documentSrcName == null) {
            throw new IllegalArgumentException("Top-level DocBook XML document source name must not be null.");
        }
        Set<String> docNames = NameUtils.getDocumentNames(sourceDirectory, documentSrcName);
        if (docNames.isEmpty()) {
            throw new IOException("No document names found.");
        }
        String extra = "";
        if (baseName != null && !baseName.equalsIgnoreCase("")) {
            extra = File.separator + baseName;
        }
        SuffixFileFilter onlyImages = new SuffixFileFilter(IMAGE_FILE_SUFFIXES);
        for (String docName : docNames) {
            File srcDir = FileUtils.getFile((File)sourceDirectory, (String[])new String[]{docName, "images"});
            File destDir = FileUtils.getFile((File)outputDirectory, (String[])new String[]{docType, docName + extra, "images"});
            if (srcDir.exists()) {
                FileUtils.copyDirectory((File)srcDir, (File)destDir, (FileFilter)onlyImages);
            }
            String shared = "shared" + File.separator + "images";
            srcDir = new File(sourceDirectory, shared);
            destDir = FileUtils.getFile((File)outputDirectory, (String[])new String[]{docType, docName + extra, shared});
            if (!srcDir.exists()) continue;
            FileUtils.copyDirectory((File)srcDir, (File)destDir, (FileFilter)onlyImages);
        }
    }

    private ImageCopier() {
    }
}

