/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.forgerock.doc.maven.utils.FilteredFileUpdater;
import org.forgerock.doc.maven.utils.NameUtils;

public final class HtmlUtils {
    public static void addHtaccess(String baseDir, File htaccess) throws IOException {
        FileUtils.copyFileToDirectory((File)htaccess, (File)new File(baseDir));
    }

    public static void addCustomCss(File cssFile, File srcDir, String documentSrcName) throws IOException {
        if (!cssFile.exists()) {
            throw new IOException(cssFile.getPath() + " not found");
        }
        String cssString = FileUtils.readFileToString((File)cssFile);
        Set<String> docNames = NameUtils.getDocumentNames(srcDir, documentSrcName);
        if (docNames.isEmpty()) {
            throw new IOException("No document names found.");
        }
        for (String docName : docNames) {
            File parent = new File(srcDir, docName);
            File xmlFile = new File(parent, cssFile.getName() + ".xml");
            if (xmlFile.exists()) continue;
            FileUtils.write((File)xmlFile, (CharSequence)"<?xml version=\"1.0\"?>\n", (boolean)true);
            FileUtils.write((File)xmlFile, (CharSequence)"<style>\n", (boolean)true);
            FileUtils.write((File)xmlFile, (CharSequence)cssString, (boolean)true);
            FileUtils.write((File)xmlFile, (CharSequence)"</style>\n", (boolean)true);
        }
    }

    public static List<File> updateHtml(String baseDir, Map<String, String> replacements) throws IOException {
        IOFileFilter dirFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.directoryFileFilter(), HiddenFileFilter.VISIBLE});
        IOFileFilter fileFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.fileFileFilter(), FileFilterUtils.suffixFileFilter((String)".html")});
        IOFileFilter filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{dirFilter, fileFilter});
        FilteredFileUpdater ffu = new FilteredFileUpdater(replacements, (FileFilter)filter);
        return ffu.update(new File(baseDir));
    }

    public static void fixResourceLinks(String htmlDir, String resourcesDirBaseName) throws IOException {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("href='../" + resourcesDirBaseName, "href='../../" + resourcesDirBaseName);
        replacements.put("href=\"../" + resourcesDirBaseName, "href=\"../../" + resourcesDirBaseName);
        HtmlUtils.updateHtml(htmlDir, replacements);
    }

    private HtmlUtils() {
    }
}

