/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;

public class FilteredFileUpdater
extends DirectoryWalker<File> {
    private final Map<String, String> msReplacements;

    public FilteredFileUpdater(Map<String, String> replacements, FileFilter filterToMatch) {
        super(filterToMatch, -1);
        this.msReplacements = replacements;
    }

    public final List<File> update(File startDirectory) throws IOException {
        ArrayList<File> results = new ArrayList<File>();
        this.walk(startDirectory, results);
        return results;
    }

    protected final void handleFile(File file, int depth, Collection<File> results) throws IOException {
        if (file.isFile()) {
            String data = FileUtils.readFileToString((File)file, (String)"UTF-8");
            for (String key : this.msReplacements.keySet()) {
                data = data.replace(key, this.msReplacements.get(key));
            }
            FileUtils.deleteQuietly((File)file);
            FileUtils.writeStringToFile((File)file, (String)data, (String)"UTF-8");
            results.add(file);
        }
    }
}

