/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;

public final class BootstrapCopier {
    private final String[] bootstrapLogoResources = new String[]{"/logos/hero-bg-01.png", "/logos/left-shape-4.png", "/logos/Icon_External_Link.png", "/logos/forgerock-header-logo.png", "/logos/FR_logo_horiz_FC_rev.png"};
    private final String[] bootstrapSwfResources = new String[]{"/swf/ZeroClipboard.swf"};
    private String[] outputDirectories;

    public BootstrapCopier(String[] outputDirectories) {
        this.outputDirectories = outputDirectories;
    }

    public void copy() throws IOException {
        this.addBootstrapLogos();
        this.addBootstrapSwf();
    }

    private void addBootstrapLogos() throws IOException {
        this.addBootstrapResources(this.bootstrapLogoResources);
    }

    private void addBootstrapSwf() throws IOException {
        this.addBootstrapResources(this.bootstrapSwfResources);
    }

    private void addBootstrapResources(String[] resources) throws IOException {
        for (String resource : resources) {
            URL resourceUrl = this.getClass().getResource(resource);
            if (resourceUrl != null) {
                for (String outputDirectory : this.outputDirectories) {
                    File styleSheetFile = FileUtils.getFile((String[])new String[]{outputDirectory, "includes", resource});
                    FileUtils.copyURLToFile((URL)resourceUrl, (File)styleSheetFile);
                }
                continue;
            }
            System.err.println("WARNING: Resource " + resource + " cannot be found!");
        }
    }
}

