/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.site;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class Layout {
    private AbstractDocbkxMojo m;
    private final Executor executor;

    public Layout(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.executor = new Executor();
    }

    public void execute() throws MojoExecutionException {
        this.executor.layout();
    }

    private MojoExecutor.Element getResources() throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> r = new ArrayList<MojoExecutor.Element>();
        List<AbstractDocbkxMojo.Format> formats = this.m.getFormats();
        String outputDir = this.m.path(this.m.getDocbkxOutputDirectory());
        if (formats.contains((Object)AbstractDocbkxMojo.Format.epub)) {
            r.add(MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)(outputDir + "/epub/")), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"**/*.epub")})}));
        }
        if (formats.contains((Object)AbstractDocbkxMojo.Format.html)) {
            r.add(MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)(outputDir + "/")), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"html/**/*.*")})}));
        }
        if (formats.contains((Object)AbstractDocbkxMojo.Format.pdf)) {
            r.add(MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)(outputDir + "/pdf/")), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"**/*.pdf")})}));
        }
        if (formats.contains((Object)AbstractDocbkxMojo.Format.rtf)) {
            r.add(MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)(outputDir + "/rtf/")), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"**/*.rtf")})}));
        }
        if (formats.contains((Object)AbstractDocbkxMojo.Format.xhtml5)) {
            r.add(MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)(outputDir + "/")), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"xhtml/**/*.*")})}));
        }
        if (formats.contains((Object)AbstractDocbkxMojo.Format.bootstrap)) {
            r.add(MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)(outputDir + "/")), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"bootstrap/**/*.*")})}));
        }
        return MojoExecutor.element((String)"resources", (MojoExecutor.Element[])r.toArray(new MojoExecutor.Element[r.size()]));
    }

    class Executor
    extends MojoExecutor {
        Executor() {
        }

        public void layout() throws MojoExecutionException {
            String siteDocDirectory = Layout.this.m.path(Layout.this.m.getSiteDirectory()) + "/doc";
            Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"org.apache.maven.plugins"), (String)Executor.artifactId((String)"maven-resources-plugin"), (String)Executor.version((String)Layout.this.m.getMavenResourcesVersion())), (String)Executor.goal((String)"copy-resources"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{Executor.element((String)Executor.name((String)"encoding"), (String)"UTF-8"), Executor.element((String)Executor.name((String)"outputDirectory"), (String)siteDocDirectory), Layout.this.getResources()}), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)Layout.this.m.getProject(), (MavenSession)Layout.this.m.getSession(), (BuildPluginManager)Layout.this.m.getPluginManager()));
            if (Layout.this.m.getFormats().contains((Object)AbstractDocbkxMojo.Format.webhelp)) {
                String webHelpDir = Layout.this.m.path(Layout.this.m.getDocbkxOutputDirectory()) + "/webhelp";
                Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"org.apache.maven.plugins"), (String)Executor.artifactId((String)"maven-resources-plugin"), (String)Executor.version((String)Layout.this.m.getMavenResourcesVersion())), (String)Executor.goal((String)"copy-resources"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{Executor.element((String)Executor.name((String)"encoding"), (String)"UTF-8"), Executor.element((String)Executor.name((String)"outputDirectory"), (String)(siteDocDirectory + "/webhelp")), Executor.element((String)Executor.name((String)"resources"), (MojoExecutor.Element[])new MojoExecutor.Element[]{Executor.element((String)Executor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{Executor.element((String)Executor.name((String)"directory"), (String)webHelpDir), Executor.element((String)Executor.name((String)"excludes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{Executor.element((String)Executor.name((String)"exclude"), (String)"**/*.target.db")})})})}), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)Layout.this.m.getProject(), (MavenSession)Layout.this.m.getSession(), (BuildPluginManager)Layout.this.m.getPluginManager()));
            }
            if (Layout.this.m.doCopyResourceFiles() && Layout.this.m.getResourcesDirectory().exists()) {
                ArrayList<String> directories = new ArrayList<String>();
                if (Layout.this.m.getFormats().contains((Object)AbstractDocbkxMojo.Format.bootstrap)) {
                    directories.add("bootstrap");
                }
                if (Layout.this.m.getFormats().contains((Object)AbstractDocbkxMojo.Format.html)) {
                    directories.add("html");
                }
                if (Layout.this.m.getFormats().contains((Object)AbstractDocbkxMojo.Format.webhelp)) {
                    directories.add("webhelp");
                }
                if (Layout.this.m.getFormats().contains((Object)AbstractDocbkxMojo.Format.xhtml5)) {
                    directories.add("xhtml");
                }
                try {
                    for (String directory : directories) {
                        File targetDirectory = FileUtils.getFile((File)Layout.this.m.getSiteDirectory(), (String[])new String[]{"doc", directory});
                        FileUtils.copyDirectoryToDirectory((File)Layout.this.m.getResourcesDirectory(), (File)targetDirectory);
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy resources", (Exception)e);
                }
            }
        }
    }
}

