/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.release;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.forgerock.doc.maven.AbstractDocbkxMojo;

public class IndexHtml {
    private AbstractDocbkxMojo m;

    public IndexHtml(AbstractDocbkxMojo mojo) {
        this.m = mojo;
    }

    public void execute() throws MojoExecutionException {
        if (!this.m.keepCustomIndexHtml()) {
            File indexHtml = new File(this.m.getReleaseVersionPath(), "index.html");
            FileUtils.deleteQuietly((File)indexHtml);
            try {
                String content = IOUtils.toString((URL)this.getClass().getResource("/dfo.index.html"), (String)"UTF-8");
                content = content.replace("PRODUCT", this.m.getProjectName().toLowerCase());
                content = content.replace("VERSION", this.m.getReleaseVersion());
                content = content.replace("ANALYTICS-ID", this.m.getGoogleAnalyticsId());
                FileUtils.writeStringToFile((File)indexHtml, (String)content, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }
}

