/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.pre;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.utils.FilteredFileCopier;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class JCite {
    private AbstractDocbkxMojo m;
    private final Executor executor;
    private final String sourceDir;
    private final File tempOutputDirectory;
    private final String outputDir;

    public JCite(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.executor = new Executor();
        this.sourceDir = this.m.path(this.m.getDocbkxModifiableSourcesDirectory());
        this.tempOutputDirectory = new File(this.m.getBuildDirectory(), "docbkx-jcite");
        this.outputDir = this.m.path(this.tempOutputDirectory);
    }

    public void execute() throws MojoExecutionException {
        this.executor.runJCite();
        try {
            FilteredFileCopier.copyOthers(".xml", this.m.getDocbkxModifiableSourcesDirectory(), this.tempOutputDirectory);
            FileUtils.copyDirectory((File)this.tempOutputDirectory, (File)this.m.getDocbkxModifiableSourcesDirectory());
            FileUtils.deleteDirectory((File)this.tempOutputDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    class Executor
    extends MojoExecutor {
        Executor() {
        }

        void runJCite() throws MojoExecutionException {
            Xpp3Dom mkdir = new Xpp3Dom("mkdir");
            mkdir.setAttribute("dir", JCite.this.outputDir);
            Xpp3Dom taskdef = new Xpp3Dom("taskdef");
            taskdef.setAttribute("name", "jcite");
            taskdef.setAttribute("classname", "ch.arrenbrecht.jcite.JCiteTask");
            taskdef.setAttribute("classpathref", "maven.plugin.classpath");
            Xpp3Dom jcite = new Xpp3Dom("jcite");
            jcite.setAttribute("srcdir", JCite.this.sourceDir);
            jcite.setAttribute("destdir", JCite.this.outputDir);
            Xpp3Dom sourcepath = new Xpp3Dom("sourcepath");
            if (JCite.this.m.getJCiteSourcePaths() != null && !JCite.this.m.getJCiteSourcePaths().isEmpty()) {
                for (File sourcePath : JCite.this.m.getJCiteSourcePaths()) {
                    String location = FilenameUtils.separatorsToSystem((String)sourcePath.getPath());
                    Xpp3Dom pathelement = new Xpp3Dom("pathelement");
                    pathelement.setAttribute("location", location);
                    sourcepath.addChild(pathelement);
                }
            } else {
                Xpp3Dom pathelement = new Xpp3Dom("pathelement");
                pathelement.setAttribute("location", "src/main/java");
                sourcepath.addChild(pathelement);
            }
            jcite.addChild(sourcepath);
            Xpp3Dom include = new Xpp3Dom("include");
            include.setAttribute("name", "**/*.xml");
            jcite.addChild(include);
            Xpp3Dom target = new Xpp3Dom("target");
            target.addChild(mkdir);
            target.addChild(taskdef);
            target.addChild(jcite);
            Xpp3Dom configuration = new Xpp3Dom("configuration");
            configuration.addChild(target);
            Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"org.apache.maven.plugins"), (String)Executor.artifactId((String)"maven-antrun-plugin"), (String)Executor.version((String)"1.7"), (List)Executor.dependencies((Dependency[])new Dependency[]{Executor.dependency((String)Executor.groupId((String)"org.mcraig"), (String)Executor.artifactId((String)"jcite"), (String)Executor.version((String)JCite.this.m.getJCiteVersion()))})), (String)Executor.goal((String)"run"), (Xpp3Dom)configuration, (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)JCite.this.m.getProject(), (MavenSession)JCite.this.m.getSession(), (BuildPluginManager)JCite.this.m.getPluginManager()));
        }
    }
}

