/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.pre;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class Filter {
    private AbstractDocbkxMojo m;
    private final Executor executor;
    private final String sourceDirectory;
    private final File tempOutputDirectory;
    private final String filteredOutputDirectory;

    public Filter(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.executor = new Executor();
        this.sourceDirectory = this.m.path(this.m.getDocbkxModifiableSourcesDirectory());
        this.tempOutputDirectory = new File(this.m.getBuildDirectory(), "docbkx-filtered");
        this.filteredOutputDirectory = this.m.path(this.tempOutputDirectory);
    }

    public void execute() throws MojoExecutionException {
        this.executor.filter();
        try {
            FileUtils.copyDirectory((File)this.tempOutputDirectory, (File)this.m.getDocbkxModifiableSourcesDirectory());
            FileUtils.deleteDirectory((File)this.tempOutputDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    class Executor
    extends MojoExecutor {
        Executor() {
        }

        void filter() throws MojoExecutionException {
            Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"org.apache.maven.plugins"), (String)Executor.artifactId((String)"maven-resources-plugin"), (String)Executor.version((String)Filter.this.m.getMavenResourcesVersion()), (List)Executor.dependencies((Dependency[])new Dependency[]{Executor.dependency((String)Executor.groupId((String)"org.apache.maven.shared"), (String)Executor.artifactId((String)"maven-filtering"), (String)Executor.version((String)Filter.this.m.getMavenFilteringVersion()))})), (String)Executor.goal((String)"copy-resources"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{Executor.element((String)Executor.name((String)"outputDirectory"), (String)Filter.this.filteredOutputDirectory), Executor.element((String)Executor.name((String)"nonFilteredFileExtensions"), (MojoExecutor.Element[])new MojoExecutor.Element[]{Executor.element((String)Executor.name((String)"nonFilteredFileExtension"), (String)"eps"), Executor.element((String)Executor.name((String)"nonFilteredFileExtension"), (String)"pptx"), Executor.element((String)Executor.name((String)"nonFilteredFileExtension"), (String)"tiff")}), Executor.element((String)Executor.name((String)"resources"), (MojoExecutor.Element[])new MojoExecutor.Element[]{Executor.element((String)Executor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{Executor.element((String)Executor.name((String)"directory"), (String)Filter.this.sourceDirectory), Executor.element((String)Executor.name((String)"filtering"), (String)"true"), Executor.element((String)Executor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{Executor.element((String)Executor.name((String)"include"), (String)"**/*.*")})})})}), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)Filter.this.m.getProject(), (MavenSession)Filter.this.m.getSession(), (BuildPluginManager)Filter.this.m.getPluginManager()));
        }
    }
}

