/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.pre;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.forgerock.doc.maven.AbstractDocbkxMojo;

public class CurrentDocId {
    private AbstractDocbkxMojo m;
    private static final String CURRENT_DOCID = "CURRENT.DOCID#";

    public CurrentDocId(AbstractDocbkxMojo mojo) {
        this.m = mojo;
    }

    public void execute() throws MojoExecutionException {
        Set<String> docNames = this.m.getDocNames();
        String sourceEncoding = this.m.getProject().getProperties().getProperty("project.build.sourceEncoding", "UTF-8");
        for (String docName : docNames) {
            File documentDirectory = new File(this.m.getDocbkxModifiableSourcesDirectory(), docName);
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(documentDirectory);
            scanner.setIncludes(new String[]{"**/*.xml"});
            scanner.addDefaultExcludes();
            scanner.scan();
            for (String docFile : scanner.getIncludedFiles()) {
                try {
                    File documentFile = new File(documentDirectory, docFile);
                    String content = FileUtils.fileRead((File)documentFile, (String)sourceEncoding);
                    String newContent = StringUtils.replace((String)content, (String)CURRENT_DOCID, (String)(docName + "#"));
                    FileUtils.fileWrite((File)documentFile, (String)sourceEncoding, (String)newContent);
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
        }
    }
}

