/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.pre;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class CommonContent {
    private AbstractDocbkxMojo m;
    private final Executor executor;

    public CommonContent(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.executor = new Executor();
    }

    public void execute() throws MojoExecutionException {
        if (this.m.doOverwriteProjectFilesWithSharedContent()) {
            File sharedContentUnpackDir = this.m.getDocbkxModifiableSourcesDirectory();
            this.executor.unpack(this.m.path(sharedContentUnpackDir));
        } else {
            try {
                File sharedContentUnpackDir = this.createTemporaryDirectory();
                this.executor.unpack(this.m.path(sharedContentUnpackDir));
                FileUtils.copyDirectory((File)this.m.getDocbkxModifiableSourcesDirectory(), (File)sharedContentUnpackDir);
                FileUtils.deleteDirectory((File)this.m.getDocbkxModifiableSourcesDirectory());
                FileUtils.moveDirectory((File)sharedContentUnpackDir, (File)this.m.getDocbkxModifiableSourcesDirectory());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to unpack common content.", (Exception)e);
            }
        }
    }

    private File createTemporaryDirectory() throws IOException {
        File temporaryDirectory = new File(this.m.getBuildDirectory(), Long.toString(System.nanoTime()));
        if (!temporaryDirectory.mkdir() && temporaryDirectory.canWrite()) {
            throw new IOException("Failed to create temporary directory: " + temporaryDirectory.getAbsolutePath());
        }
        return temporaryDirectory;
    }

    class Executor
    extends MojoExecutor {
        Executor() {
        }

        public void unpack(String outputDir) throws MojoExecutionException {
            Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"org.apache.maven.plugins"), (String)Executor.artifactId((String)"maven-dependency-plugin"), (String)Executor.version((String)CommonContent.this.m.getMavenDependencyVersion())), (String)Executor.goal((String)"unpack"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{Executor.element((String)"artifactItems", (MojoExecutor.Element[])new MojoExecutor.Element[]{Executor.element((String)"artifactItem", (MojoExecutor.Element[])new MojoExecutor.Element[]{Executor.element((String)"groupId", (String)CommonContent.this.m.getCommonContentGroupId()), Executor.element((String)"artifactId", (String)CommonContent.this.m.getCommonContentArtifactId()), Executor.element((String)"version", (String)CommonContent.this.m.getCommonContentVersion()), Executor.element((String)"type", (String)"jar"), Executor.element((String)"overWrite", (String)"true"), Executor.element((String)"outputDirectory", (String)outputDir), Executor.element((String)"includes", (String)"**/*.*")})})}), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)CommonContent.this.m.getProject(), (MavenSession)CommonContent.this.m.getSession(), (BuildPluginManager)CommonContent.this.m.getPluginManager()));
        }
    }
}

