/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.pre;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class ArtifactBuilder {
    private AbstractDocbkxMojo m;
    private final Executor executor;
    private Configuration configuration;

    public ArtifactBuilder(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.executor = new Executor();
        this.configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        this.configuration.setClassForTemplateLoading(ArtifactBuilder.class, "/templates");
        this.configuration.setDefaultEncoding("UTF-8");
        this.configuration.setTemplateExceptionHandler(TemplateExceptionHandler.DEBUG_HANDLER);
    }

    private String getDescriptorPath(File descriptorFile) throws IOException, TemplateException {
        Template template = this.configuration.getTemplate("artifact.ftl");
        FileOutputStream out = FileUtils.openOutputStream((File)descriptorFile);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        template.process(this.getModel(), (Writer)writer);
        ((Writer)writer).close();
        out.close();
        return descriptorFile.getPath();
    }

    private Map<String, String> getModel() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("modifiedSourcesDirectory", this.m.path(this.m.getDocbkxModifiableSourcesDirectory()));
        return map;
    }

    public void execute() throws MojoExecutionException {
        this.executor.build();
    }

    class Executor
    extends MojoExecutor {
        Executor() {
        }

        public void build() throws MojoExecutionException {
            String descriptorPath;
            File descriptorFile;
            try {
                descriptorFile = File.createTempFile("descriptor", "xml");
                descriptorPath = ArtifactBuilder.this.getDescriptorPath(descriptorFile);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to get assembly descriptor", e);
            }
            Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"org.apache.maven.plugins"), (String)Executor.artifactId((String)"maven-assembly-plugin"), (String)Executor.version((String)ArtifactBuilder.this.m.getMavenAssemblyVersion())), (String)Executor.goal((String)"single"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{Executor.element((String)"descriptors", (MojoExecutor.Element[])new MojoExecutor.Element[]{Executor.element((String)"descriptor", (String)descriptorPath)})}), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)ArtifactBuilder.this.m.getProject(), (MavenSession)ArtifactBuilder.this.m.getSession(), (BuildPluginManager)ArtifactBuilder.this.m.getPluginManager()));
            if (descriptorFile.exists()) {
                descriptorFile.delete();
            }
        }
    }
}

