/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.pre;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class ArbitraryResourceCopier {
    private AbstractDocbkxMojo m;
    private final Executor executor;

    public ArbitraryResourceCopier(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.executor = new Executor();
    }

    public void execute() throws MojoExecutionException {
        this.executor.copy();
    }

    class Executor
    extends MojoExecutor {
        Executor() {
        }

        public void copy() throws MojoExecutionException {
            if (ArbitraryResourceCopier.this.m.doCopyResourceFiles() && ArbitraryResourceCopier.this.m.getResourcesDirectory().exists()) {
                ArrayList<String> directories = new ArrayList<String>();
                if (ArbitraryResourceCopier.this.m.getFormats().contains((Object)AbstractDocbkxMojo.Format.bootstrap)) {
                    directories.add("bootstrap");
                }
                if (ArbitraryResourceCopier.this.m.getFormats().contains((Object)AbstractDocbkxMojo.Format.html)) {
                    directories.add("html");
                }
                if (ArbitraryResourceCopier.this.m.getFormats().contains((Object)AbstractDocbkxMojo.Format.webhelp)) {
                    directories.add("webhelp");
                }
                if (ArbitraryResourceCopier.this.m.getFormats().contains((Object)AbstractDocbkxMojo.Format.xhtml5)) {
                    directories.add("xhtml");
                }
                try {
                    for (String directory : directories) {
                        File targetDirectory = FileUtils.getFile((File)ArbitraryResourceCopier.this.m.getDocbkxOutputDirectory(), (String[])new String[]{directory});
                        FileUtils.copyDirectoryToDirectory((File)ArbitraryResourceCopier.this.m.getResourcesDirectory(), (File)targetDirectory);
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy resources", (Exception)e);
                }
            }
        }
    }
}

