/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.post;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.forgerock.doc.maven.AbstractDocbkxMojo;

public class ManpagePost
extends AbstractDocbkxMojo {
    private AbstractDocbkxMojo m;

    public ManpagePost(AbstractDocbkxMojo mojo) {
        this.m = mojo;
    }

    public void execute() throws MojoExecutionException {
        File manPageOutputDir = new File(this.m.getDocbkxOutputDirectory(), "manpages");
        File generatedManPageDir = new File(manPageOutputDir.getAbsolutePath().replace(' ', '_'));
        if (generatedManPageDir.equals(manPageOutputDir)) {
            return;
        }
        if (!generatedManPageDir.exists() || !this.hasChildren(generatedManPageDir)) {
            this.m.getLog().info((CharSequence)("No man pages found in " + generatedManPageDir.getAbsolutePath()));
            return;
        }
        try {
            FileUtils.copyDirectory((File)generatedManPageDir, (File)manPageOutputDir, (FileFilter)FileFilterUtils.trueFileFilter());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        File topGeneratedDirWithUnderscore = this.getTopAncestorWithUnderscore(generatedManPageDir);
        try {
            FileUtils.deleteDirectory((File)topGeneratedDirWithUnderscore);
        }
        catch (IOException e) {
            this.m.getLog().info((CharSequence)("Failed to delete generated man page dir: " + generatedManPageDir + e.getMessage()));
        }
    }

    private boolean hasChildren(File directory) {
        String[] children = directory.list();
        return children.length > 0;
    }

    private File getTopAncestorWithUnderscore(File directory) {
        File topAncestorWithUnderscore = directory;
        while (topAncestorWithUnderscore.getParent().contains("_")) {
            topAncestorWithUnderscore = topAncestorWithUnderscore.getParentFile();
        }
        return topAncestorWithUnderscore;
    }
}

