/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.post;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.utils.HtmlUtils;
import org.forgerock.doc.maven.utils.SyntaxHighlighterCopier;

public class Html {
    private AbstractDocbkxMojo m;
    private String[] outputDirectories;

    public Html(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.outputDirectories = new String[2];
        this.outputDirectories[0] = "";
        this.outputDirectories[1] = File.separator + FilenameUtils.getBaseName((String)this.m.getDocumentSrcName());
    }

    public void execute() throws MojoExecutionException {
        this.addScript();
        File htmlDir = new File(this.m.getDocbkxOutputDirectory(), "html");
        String chunkDirName = FilenameUtils.getBaseName((String)this.m.getDocumentSrcName());
        String[] outputDirectories = new String[2 * this.m.getDocNames().size()];
        int i = 0;
        for (String docName : this.m.getDocNames()) {
            File docDir = new File(htmlDir, docName);
            outputDirectories[i] = docDir.getPath();
            outputDirectories[++i] = new File(docDir, chunkDirName).getPath();
            ++i;
        }
        SyntaxHighlighterCopier copier = new SyntaxHighlighterCopier(outputDirectories);
        try {
            copier.copy();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy files: " + e.getMessage(), (Exception)e);
        }
        this.editBuiltHtml(htmlDir.getPath());
        if (this.m.doCopyResourceFiles() && this.m.getResourcesDirectory().exists()) {
            String baseName = FilenameUtils.getBaseName((String)this.m.getResourcesDirectory().getPath());
            for (String docName : this.m.getDocNames()) {
                File docDir = new File(htmlDir, docName);
                try {
                    HtmlUtils.fixResourceLinks(new File(docDir, chunkDirName).getPath(), baseName);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to update resource links", (Exception)e);
                }
            }
        }
    }

    private void addScript() throws MojoExecutionException {
        String scriptString;
        URL scriptUrl = this.getClass().getResource("/js/" + this.m.getJavaScriptFileName());
        try {
            scriptString = IOUtils.toString((URL)scriptUrl);
        }
        catch (IOException ie) {
            throw new MojoExecutionException("Failed to read " + scriptUrl, (Exception)ie);
        }
        if (scriptString == null) {
            throw new MojoExecutionException(scriptUrl + " was empty");
        }
        scriptString = scriptString.replace("PROJECT_NAME", this.m.getProjectName().toLowerCase());
        scriptString = scriptString.replace("PROJECT_VERSION", this.m.getProjectVersion());
        scriptString = scriptString.replace("LATEST_JSON", this.m.getLatestJson());
        scriptString = scriptString.replace("DOCS_SITE", this.m.getDocsSite());
        scriptString = scriptString.replace("EOSL_JSON", this.m.getEoslJson());
        for (String outputDirectory : this.outputDirectories) {
            for (String docName : this.m.getDocNames()) {
                File parent = FileUtils.getFile((File)this.m.getDocbkxOutputDirectory(), (String[])new String[]{"html", docName + outputDirectory});
                File scriptFile = new File(parent, this.m.getJavaScriptFileName());
                try {
                    FileUtils.writeStringToFile((File)scriptFile, (String)scriptString, (String)"UTF-8");
                }
                catch (IOException ie) {
                    throw new MojoExecutionException("Failed to write to " + scriptFile.getPath(), (Exception)ie);
                }
            }
        }
    }

    final void editBuiltHtml(String htmlDir) throws MojoExecutionException {
        try {
            HashMap<String, String> replacements = new HashMap<String, String>();
            String doctype = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/starthtml-doctype.txt"), (String)"UTF-8");
            replacements.put("<html>", doctype);
            String robots = "<head>" + System.getProperty("line.separator") + IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/robots.txt"), (String)"UTF-8");
            replacements.put("<head>", robots);
            String favicon = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/endhead-favicon.txt"), (String)"UTF-8");
            favicon = favicon.replace("FAVICON-LINK", this.m.getFaviconLink());
            replacements.put("</head>", favicon);
            String linkToJira = this.getLinkToJira();
            String gascript = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/endbody-ga.txt"), (String)"UTF-8");
            gascript = gascript.replace("ANALYTICS-ID", this.m.getGoogleAnalyticsId());
            replacements.put("</body>", linkToJira + "\n" + gascript);
            HtmlUtils.updateHtml(htmlDir, replacements);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to update output HTML correctly: " + e.getMessage());
        }
    }

    private String getLinkToJira() {
        String link = "<p>&nbsp;</p><div id=\"footer\"><p>Something wrong on this page? <a href=\"JIRA-URL\">Log a documentation bug.</a></p></div>";
        String jiraURL = "https://github.com/OpenIdentityPlatform/" + this.m.getProjectName() + "/issues/new";
        link = !jiraURL.contains("pid") ? "" : link.replaceFirst("JIRA-URL", jiraURL);
        return link;
    }
}

