/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.post;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.utils.BootstrapCopier;
import org.forgerock.doc.maven.utils.HtmlUtils;
import org.forgerock.doc.maven.utils.NameUtils;

public class Bootstrap {
    private AbstractDocbkxMojo m;
    private String[] outputDirectories;

    public Bootstrap(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.outputDirectories = new String[1];
        this.outputDirectories[0] = "";
    }

    public void execute() throws MojoExecutionException {
        File htmlDir = new File(this.m.getDocbkxOutputDirectory(), "bootstrap");
        String[] outputDirectories = new String[this.m.getDocNames().size()];
        int i = 0;
        for (String docName : this.m.getDocNames()) {
            File docDir = new File(htmlDir, docName);
            if (this.m.getFormats().contains((Object)AbstractDocbkxMojo.Format.pdf)) {
                this.addPDFLink(docDir.getPath(), docName);
            }
            outputDirectories[i] = docDir.getPath();
            ++i;
        }
        this.editBuiltHtml(htmlDir.getPath());
        if (this.m.isDraftMode().equals("yes")) {
            this.addDraftAlert(htmlDir.getPath());
        }
        BootstrapCopier copier = new BootstrapCopier(outputDirectories);
        try {
            copier.copy();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy files: " + e.getMessage(), (Exception)e);
        }
    }

    final void editBuiltHtml(String htmlDir) throws MojoExecutionException {
        try {
            HashMap<String, String> replacements = new HashMap<String, String>();
            String gascript = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/endhead-ga.txt"), (String)"UTF-8");
            gascript = gascript.replace("ANALYTICS-ID", this.m.getGoogleAnalyticsId());
            replacements.put("</head>", gascript);
            HtmlUtils.updateHtml(htmlDir, replacements);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to update output HTML correctly: " + e.getMessage());
        }
    }

    final void addDraftAlert(String htmlDir) throws MojoExecutionException {
        try {
            HashMap<String, String> replacements = new HashMap<String, String>();
            String draftAlert = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/endbody-draftalert.txt"), (String)"UTF-8");
            replacements.put("</body>", draftAlert);
            HtmlUtils.updateHtml(htmlDir, replacements);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to update output HTML correctly: " + e.getMessage());
        }
    }

    final void addPDFLink(String htmlDir, String docName) throws MojoExecutionException {
        try {
            HashMap<String, String> replacements = new HashMap<String, String>();
            String linkToPdf = this.getLinkToPdf(docName);
            replacements.put("<ul id=\"pdf-link\">", linkToPdf);
            HtmlUtils.updateHtml(htmlDir, replacements);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to inject PDF link HTML correctly: " + e.getMessage());
        }
    }

    private String getLinkToPdf(String docName) {
        String link = "<ul id=\"pdf-link\" class=\"nav navbar-nav navbar-right hidden-xs\"><li><a href=\"PDF-URL\" target=\"_blank\"><span class=\"glyphicon glyphicon-save\"></span> Download PDF Version</a></li>";
        String pdfUrl = "../../" + NameUtils.renameDoc(this.m.getProjectName(), docName, "pdf");
        link = link.replaceFirst("PDF-URL", pdfUrl);
        return link;
    }
}

