/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.utils.ImageCopier;
import org.forgerock.doc.maven.utils.OLinkUtils;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class Xhtml5 {
    private AbstractDocbkxMojo m;
    private final Executor executor;

    public Xhtml5(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.executor = new Executor();
    }

    public void execute() throws MojoExecutionException {
        this.executor.prepareOlinkDB();
        this.executor.build();
    }

    final String getTargetDB() throws MojoExecutionException {
        File targetDB = new File(this.m.getBuildDirectory(), "olinkdb-xhtml.xml");
        try {
            OLinkUtils.createTargetDatabase(targetDB, "xhtml5", this.m);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to write link target database: " + targetDB.getPath(), e);
        }
        return targetDB.getPath();
    }

    class Executor
    extends MojoExecutor {
        Executor() {
        }

        void prepareOlinkDB() throws MojoExecutionException {
            for (String docName : Xhtml5.this.m.getDocNames()) {
                ArrayList<MojoExecutor.Element> cfg = new ArrayList<MojoExecutor.Element>();
                cfg.add(Executor.element((String)Executor.name((String)"chunkedOutput"), (String)"false"));
                cfg.add(Executor.element((String)Executor.name((String)"collectXrefTargets"), (String)"only"));
                cfg.add(Executor.element((String)Executor.name((String)"includes"), (String)(docName + "/" + Xhtml5.this.m.getDocumentSrcName())));
                cfg.add(Executor.element((String)Executor.name((String)"sourceDirectory"), (String)Xhtml5.this.m.path(Xhtml5.this.m.getDocbkxModifiableSourcesDirectory())));
                cfg.add(Executor.element((String)Executor.name((String)"xhtml5Customization"), (String)Xhtml5.this.m.path(Xhtml5.this.m.getXhtml5Customization())));
                cfg.add(Executor.element((String)Executor.name((String)"xincludeSupported"), (String)Xhtml5.this.m.isXincludeSupported()));
                cfg.add(Executor.element((String)Executor.name((String)"targetDirectory"), (String)(Xhtml5.this.m.path(Xhtml5.this.m.getDocbkxOutputDirectory()) + "/xhtml")));
                cfg.add(Executor.element((String)Executor.name((String)"targetsFilename"), (String)(Xhtml5.this.m.getDocumentSrcName() + ".xhtml.target.db")));
                Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"com.agilejava.docbkx"), (String)Executor.artifactId((String)"docbkx-maven-plugin"), (String)Executor.version((String)Xhtml5.this.m.getDocbkxVersion())), (String)Executor.goal((String)"generate-xhtml5"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])cfg.toArray(new MojoExecutor.Element[cfg.size()])), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)Xhtml5.this.m.getProject(), (MavenSession)Xhtml5.this.m.getSession(), (BuildPluginManager)Xhtml5.this.m.getPluginManager()));
            }
        }

        void build() throws MojoExecutionException {
            try {
                ImageCopier.copyImages("xhtml", "", Xhtml5.this.m);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy images", (Exception)e);
            }
            ArrayList<MojoExecutor.Element> cfg = new ArrayList<MojoExecutor.Element>();
            cfg.add(Executor.element((String)Executor.name((String)"chunkedOutput"), (String)"false"));
            cfg.add(Executor.element((String)Executor.name((String)"highlightSource"), (String)Xhtml5.this.m.useSyntaxHighlighting()));
            cfg.add(Executor.element((String)Executor.name((String)"includes"), (String)("*/" + Xhtml5.this.m.getDocumentSrcName())));
            cfg.add(Executor.element((String)Executor.name((String)"sectionAutolabel"), (String)Xhtml5.this.m.areSectionsAutolabeled()));
            cfg.add(Executor.element((String)Executor.name((String)"sectionLabelIncludesComponentLabel"), (String)Xhtml5.this.m.doesSectionLabelIncludeComponentLabel()));
            cfg.add(Executor.element((String)Executor.name((String)"sourceDirectory"), (String)Xhtml5.this.m.path(Xhtml5.this.m.getDocbkxModifiableSourcesDirectory())));
            cfg.add(Executor.element((String)Executor.name((String)"targetDatabaseDocument"), (String)Xhtml5.this.getTargetDB()));
            cfg.add(Executor.element((String)Executor.name((String)"targetDirectory"), (String)(Xhtml5.this.m.path(Xhtml5.this.m.getDocbkxOutputDirectory()) + "/xhtml")));
            cfg.add(Executor.element((String)Executor.name((String)"xhtml5Customization"), (String)Xhtml5.this.m.path(Xhtml5.this.m.getXhtml5Customization())));
            cfg.add(Executor.element((String)Executor.name((String)"xincludeSupported"), (String)Xhtml5.this.m.isXincludeSupported()));
            Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"com.agilejava.docbkx"), (String)Executor.artifactId((String)"docbkx-maven-plugin"), (String)Executor.version((String)Xhtml5.this.m.getDocbkxVersion())), (String)Executor.goal((String)"generate-xhtml5"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])cfg.toArray(new MojoExecutor.Element[cfg.size()])), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)Xhtml5.this.m.getProject(), (MavenSession)Xhtml5.this.m.getSession(), (BuildPluginManager)Xhtml5.this.m.getPluginManager()));
        }
    }
}

