/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.utils.ImageCopier;
import org.forgerock.doc.maven.utils.OLinkUtils;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class Webhelp {
    private AbstractDocbkxMojo m;
    private final Executor executor;

    public Webhelp(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.executor = new Executor();
    }

    public void execute() throws MojoExecutionException {
        this.executor.prepareOlinkDB();
        this.executor.build();
    }

    final String getTargetDB() throws MojoExecutionException {
        File targetDB = new File(this.m.getBuildDirectory(), "olinkdb-webhelp.xml");
        try {
            OLinkUtils.createTargetDatabase(targetDB, "webhelp", this.m);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to write link target database: " + targetDB.getPath(), e);
        }
        return targetDB.getPath();
    }

    class Executor
    extends MojoExecutor {
        Executor() {
        }

        void prepareOlinkDB() throws MojoExecutionException {
            for (String docName : Webhelp.this.m.getDocNames()) {
                ArrayList<MojoExecutor.Element> cfg = new ArrayList<MojoExecutor.Element>();
                cfg.addAll(Webhelp.this.m.getBaseConfiguration());
                cfg.add(Executor.element((String)Executor.name((String)"chapterAutolabel"), (String)"1"));
                cfg.add(Executor.element((String)Executor.name((String)"webhelpAutolabel"), (String)"1"));
                cfg.add(Executor.element((String)Executor.name((String)"webhelpCustomization"), (String)Webhelp.this.m.path(Webhelp.this.m.getWebHelpCustomization())));
                cfg.add(Executor.element((String)Executor.name((String)"collectXrefTargets"), (String)"only"));
                cfg.add(Executor.element((String)Executor.name((String)"currentDocid"), (String)docName));
                cfg.add(Executor.element((String)Executor.name((String)"includes"), (String)(docName + "/" + Webhelp.this.m.getDocumentSrcName())));
                File webHelpBase = new File(Webhelp.this.m.getDocbkxOutputDirectory(), "webhelp");
                cfg.add(Executor.element((String)Executor.name((String)"targetDirectory"), (String)Webhelp.this.m.path(webHelpBase)));
                cfg.add(Executor.element((String)Executor.name((String)"targetsFilename"), (String)(Webhelp.this.m.getDocumentSrcName() + ".webhelp.target.db")));
                Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"com.agilejava.docbkx"), (String)Executor.artifactId((String)"docbkx-maven-plugin"), (String)Executor.version((String)Webhelp.this.m.getDocbkxVersion())), (String)Executor.goal((String)"generate-webhelp"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])cfg.toArray(new MojoExecutor.Element[cfg.size()])), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)Webhelp.this.m.getProject(), (MavenSession)Webhelp.this.m.getSession(), (BuildPluginManager)Webhelp.this.m.getPluginManager()));
            }
        }

        void build() throws MojoExecutionException {
            try {
                ImageCopier.copyImages("webhelp", "", Webhelp.this.m);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy images", (Exception)e);
            }
            for (String docName : Webhelp.this.m.getDocNames()) {
                ArrayList<MojoExecutor.Element> cfg = new ArrayList<MojoExecutor.Element>();
                cfg.addAll(Webhelp.this.m.getBaseConfiguration());
                cfg.add(Executor.element((String)Executor.name((String)"chapterAutolabel"), (String)"1"));
                cfg.add(Executor.element((String)Executor.name((String)"webhelpAutolabel"), (String)"1"));
                cfg.add(Executor.element((String)Executor.name((String)"webhelpCustomization"), (String)Webhelp.this.m.path(Webhelp.this.m.getWebHelpCustomization())));
                cfg.add(Executor.element((String)Executor.name((String)"targetDatabaseDocument"), (String)Webhelp.this.getTargetDB()));
                File webHelpBase = new File(Webhelp.this.m.getDocbkxOutputDirectory(), "webhelp");
                cfg.add(Executor.element((String)Executor.name((String)"targetDirectory"), (String)Webhelp.this.m.path(webHelpBase)));
                cfg.add(Executor.element((String)Executor.name((String)"currentDocid"), (String)docName));
                cfg.add(Executor.element((String)Executor.name((String)"includes"), (String)(docName + "/" + Webhelp.this.m.getDocumentSrcName())));
                Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"com.agilejava.docbkx"), (String)Executor.artifactId((String)"docbkx-maven-plugin"), (String)Executor.version((String)Webhelp.this.m.getDocbkxVersion())), (String)Executor.goal((String)"generate-webhelp"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])cfg.toArray(new MojoExecutor.Element[cfg.size()])), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)Webhelp.this.m.getProject(), (MavenSession)Webhelp.this.m.getSession(), (BuildPluginManager)Webhelp.this.m.getPluginManager()));
                File webHelpCss = FileUtils.getFile((File)webHelpBase, (String[])new String[]{docName, "common", "css", "positioning.css"});
                File webHelpLogo = FileUtils.getFile((File)webHelpBase, (String[])new String[]{docName, "common", "images", "logo.png"});
                try {
                    FileUtils.copyFile((File)Webhelp.this.m.getWebHelpCss(), (File)webHelpCss);
                    FileUtils.copyFile((File)Webhelp.this.m.getWebHelpLogo(), (File)webHelpLogo);
                }
                catch (IOException ie) {
                    throw new MojoExecutionException("Failed to copy file", (Exception)ie);
                }
            }
        }
    }
}

