/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.utils.ImageCopier;
import org.forgerock.doc.maven.utils.OLinkUtils;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class SingleHtml {
    private AbstractDocbkxMojo m;
    private final Executor executor;

    public SingleHtml(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.executor = new Executor();
    }

    public void execute() throws MojoExecutionException {
        this.executor.prepareOlinkDB();
        this.executor.build();
    }

    final String getTargetDB() throws MojoExecutionException {
        File targetDB = new File(this.m.getBuildDirectory(), "olinkdb-single-page-html.xml");
        try {
            OLinkUtils.createTargetDatabase(targetDB, "html", this.m);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to write link target database: " + targetDB.getPath(), e);
        }
        return targetDB.getPath();
    }

    class Executor
    extends MojoExecutor {
        Executor() {
        }

        void prepareOlinkDB() throws MojoExecutionException {
            for (String docName : SingleHtml.this.m.getDocNames()) {
                ArrayList<MojoExecutor.Element> cfg = new ArrayList<MojoExecutor.Element>();
                cfg.add(Executor.element((String)Executor.name((String)"xincludeSupported"), (String)SingleHtml.this.m.isXincludeSupported()));
                cfg.add(Executor.element((String)Executor.name((String)"sourceDirectory"), (String)SingleHtml.this.m.path(SingleHtml.this.m.getDocbkxModifiableSourcesDirectory())));
                cfg.add(Executor.element((String)Executor.name((String)"chunkedOutput"), (String)"false"));
                cfg.add(Executor.element((String)Executor.name((String)"htmlCustomization"), (String)SingleHtml.this.m.path(SingleHtml.this.m.getSingleHTMLCustomization())));
                cfg.add(Executor.element((String)Executor.name((String)"collectXrefTargets"), (String)"only"));
                cfg.add(Executor.element((String)Executor.name((String)"includes"), (String)(docName + "/" + SingleHtml.this.m.getDocumentSrcName())));
                cfg.add(Executor.element((String)Executor.name((String)"targetDirectory"), (String)(SingleHtml.this.m.path(SingleHtml.this.m.getDocbkxOutputDirectory()) + "/html")));
                cfg.add(Executor.element((String)Executor.name((String)"targetsFilename"), (String)(SingleHtml.this.m.getDocumentSrcName() + ".html.target.db")));
                Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"com.agilejava.docbkx"), (String)Executor.artifactId((String)"docbkx-maven-plugin"), (String)Executor.version((String)SingleHtml.this.m.getDocbkxVersion())), (String)Executor.goal((String)"generate-html"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])cfg.toArray(new MojoExecutor.Element[cfg.size()])), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)SingleHtml.this.m.getProject(), (MavenSession)SingleHtml.this.m.getSession(), (BuildPluginManager)SingleHtml.this.m.getPluginManager()));
            }
        }

        void build() throws MojoExecutionException {
            try {
                ImageCopier.copyImages("html", "", SingleHtml.this.m);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy images", (Exception)e);
            }
            ArrayList<MojoExecutor.Element> cfg = new ArrayList<MojoExecutor.Element>();
            cfg.addAll(SingleHtml.this.m.getBaseConfiguration());
            cfg.add(Executor.element((String)Executor.name((String)"includes"), (String)("*/" + SingleHtml.this.m.getDocumentSrcName())));
            cfg.add(Executor.element((String)Executor.name((String)"chunkedOutput"), (String)"false"));
            cfg.add(Executor.element((String)Executor.name((String)"htmlCustomization"), (String)SingleHtml.this.m.path(SingleHtml.this.m.getSingleHTMLCustomization())));
            cfg.add(Executor.element((String)Executor.name((String)"targetDatabaseDocument"), (String)SingleHtml.this.getTargetDB()));
            cfg.add(Executor.element((String)Executor.name((String)"targetDirectory"), (String)(SingleHtml.this.m.path(SingleHtml.this.m.getDocbkxOutputDirectory()) + "/html")));
            Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"com.agilejava.docbkx"), (String)Executor.artifactId((String)"docbkx-maven-plugin"), (String)Executor.version((String)SingleHtml.this.m.getDocbkxVersion())), (String)Executor.goal((String)"generate-html"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])cfg.toArray(new MojoExecutor.Element[cfg.size()])), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)SingleHtml.this.m.getProject(), (MavenSession)SingleHtml.this.m.getSession(), (BuildPluginManager)SingleHtml.this.m.getPluginManager()));
        }
    }
}

