/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.utils.ImageCopier;
import org.forgerock.doc.maven.utils.OLinkUtils;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class HtmlForBootstrap {
    private AbstractDocbkxMojo m;
    private final Executor executor;

    public HtmlForBootstrap(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.executor = new Executor();
    }

    public void execute() throws MojoExecutionException {
        this.executor.prepareOlinkDB();
        this.executor.build();
    }

    final String getTargetDB() throws MojoExecutionException {
        File targetDB = new File(this.m.getBuildDirectory(), "olinkdb-bootstrap.xml");
        try {
            OLinkUtils.createTargetDatabase(targetDB, "bootstrap", this.m);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to write link target database: " + targetDB.getPath(), e);
        }
        return targetDB.getPath();
    }

    class Executor
    extends MojoExecutor {
        Executor() {
        }

        void prepareOlinkDB() throws MojoExecutionException {
            for (String docName : HtmlForBootstrap.this.m.getDocNames()) {
                ArrayList<MojoExecutor.Element> cfg = new ArrayList<MojoExecutor.Element>();
                cfg.add(Executor.element((String)Executor.name((String)"chunkedOutput"), (String)"false"));
                cfg.add(Executor.element((String)Executor.name((String)"collectXrefTargets"), (String)"only"));
                cfg.add(Executor.element((String)Executor.name((String)"includes"), (String)(docName + "/" + HtmlForBootstrap.this.m.getDocumentSrcName())));
                cfg.add(Executor.element((String)Executor.name((String)"sourceDirectory"), (String)HtmlForBootstrap.this.m.path(HtmlForBootstrap.this.m.getDocbkxModifiableSourcesDirectory())));
                cfg.add(Executor.element((String)Executor.name((String)"htmlCustomization"), (String)HtmlForBootstrap.this.m.path(HtmlForBootstrap.this.m.getBootstrapCustomization())));
                cfg.add(Executor.element((String)Executor.name((String)"xincludeSupported"), (String)HtmlForBootstrap.this.m.isXincludeSupported()));
                cfg.add(Executor.element((String)Executor.name((String)"targetDirectory"), (String)(HtmlForBootstrap.this.m.path(HtmlForBootstrap.this.m.getDocbkxOutputDirectory()) + "/bootstrap")));
                cfg.add(Executor.element((String)Executor.name((String)"targetsFilename"), (String)(HtmlForBootstrap.this.m.getDocumentSrcName() + ".html.target.db")));
                Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"com.agilejava.docbkx"), (String)Executor.artifactId((String)"docbkx-maven-plugin"), (String)Executor.version((String)HtmlForBootstrap.this.m.getDocbkxVersion())), (String)Executor.goal((String)"generate-html"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])cfg.toArray(new MojoExecutor.Element[cfg.size()])), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)HtmlForBootstrap.this.m.getProject(), (MavenSession)HtmlForBootstrap.this.m.getSession(), (BuildPluginManager)HtmlForBootstrap.this.m.getPluginManager()));
            }
        }

        void build() throws MojoExecutionException {
            try {
                ImageCopier.copyImages("bootstrap", "", HtmlForBootstrap.this.m);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy images", (Exception)e);
            }
            ArrayList<MojoExecutor.Element> cfg = new ArrayList<MojoExecutor.Element>();
            cfg.add(Executor.element((String)Executor.name((String)"chunkedOutput"), (String)"false"));
            cfg.add(Executor.element((String)Executor.name((String)"highlightSource"), (String)HtmlForBootstrap.this.m.useSyntaxHighlighting()));
            cfg.add(Executor.element((String)Executor.name((String)"includes"), (String)("*/" + HtmlForBootstrap.this.m.getDocumentSrcName())));
            cfg.add(Executor.element((String)Executor.name((String)"sectionAutolabel"), (String)HtmlForBootstrap.this.m.areSectionsAutolabeled()));
            cfg.add(Executor.element((String)Executor.name((String)"sectionLabelIncludesComponentLabel"), (String)HtmlForBootstrap.this.m.doesSectionLabelIncludeComponentLabel()));
            cfg.add(Executor.element((String)Executor.name((String)"sourceDirectory"), (String)HtmlForBootstrap.this.m.path(HtmlForBootstrap.this.m.getDocbkxModifiableSourcesDirectory())));
            cfg.add(Executor.element((String)Executor.name((String)"targetDatabaseDocument"), (String)HtmlForBootstrap.this.getTargetDB()));
            cfg.add(Executor.element((String)Executor.name((String)"targetDirectory"), (String)(HtmlForBootstrap.this.m.path(HtmlForBootstrap.this.m.getDocbkxOutputDirectory()) + "/bootstrap")));
            cfg.add(Executor.element((String)Executor.name((String)"htmlCustomization"), (String)HtmlForBootstrap.this.m.path(HtmlForBootstrap.this.m.getBootstrapCustomization())));
            cfg.add(Executor.element((String)Executor.name((String)"xincludeSupported"), (String)HtmlForBootstrap.this.m.isXincludeSupported()));
            Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"com.agilejava.docbkx"), (String)Executor.artifactId((String)"docbkx-maven-plugin"), (String)Executor.version((String)HtmlForBootstrap.this.m.getDocbkxVersion())), (String)Executor.goal((String)"generate-html"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])cfg.toArray(new MojoExecutor.Element[cfg.size()])), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)HtmlForBootstrap.this.m.getProject(), (MavenSession)HtmlForBootstrap.this.m.getSession(), (BuildPluginManager)HtmlForBootstrap.this.m.getPluginManager()));
        }
    }
}

