/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.pre.Fop;
import org.forgerock.doc.maven.utils.NameUtils;
import org.forgerock.doc.maven.utils.OLinkUtils;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class Fo {
    private AbstractDocbkxMojo m;
    private final Executor executor;
    private String format = "pdf";

    public Fo(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.executor = new Executor();
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format.equalsIgnoreCase("rtf") ? "rtf" : "pdf";
    }

    public void execute() throws MojoExecutionException {
        this.executor.prepareOlinkDB();
        this.executor.build();
    }

    final String getTargetDB() throws MojoExecutionException {
        File targetDB = new File(this.m.getBuildDirectory(), "olinkdb-" + this.getFormat() + ".xml");
        try {
            OLinkUtils.createTargetDatabase(targetDB, this.getFormat(), this.m);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to write link target database: " + targetDB.getPath(), e);
        }
        return targetDB.getPath();
    }

    class Executor
    extends MojoExecutor {
        private String targetDatabaseDocument;

        Executor() {
        }

        String getTargetDatabaseDocument() throws MojoExecutionException {
            if (this.targetDatabaseDocument == null || this.targetDatabaseDocument.isEmpty()) {
                this.targetDatabaseDocument = Fo.this.getTargetDB();
            }
            return this.targetDatabaseDocument;
        }

        void prepareOlinkDB() throws MojoExecutionException {
            if (Fo.this.getFormat().equalsIgnoreCase("rtf")) {
                return;
            }
            for (String docName : Fo.this.m.getDocNames()) {
                ArrayList<MojoExecutor.Element> cfg = new ArrayList<MojoExecutor.Element>();
                cfg.addAll(Fo.this.m.getBaseConfiguration());
                cfg.add(Executor.element((String)Executor.name((String)"xincludeSupported"), (String)Fo.this.m.isXincludeSupported()));
                cfg.add(Executor.element((String)Executor.name((String)"sourceDirectory"), (String)Fo.this.m.path(Fo.this.m.getDocbkxModifiableSourcesDirectory())));
                cfg.add(Executor.element((String)Executor.name((String)"fop1Extensions"), (String)"1"));
                cfg.add(Executor.element((String)Executor.name((String)"fopLogLevel"), (String)Fo.this.m.getFopLogLevel()));
                cfg.add(Executor.element((String)Executor.name((String)"collectXrefTargets"), (String)"yes"));
                if (Fo.this.getFormat().equalsIgnoreCase("pdf")) {
                    cfg.add(Executor.element((String)Executor.name((String)"insertOlinkPdfFrag"), (String)"1"));
                }
                cfg.add(Executor.element((String)Executor.name((String)"includes"), (String)(docName + "/" + Fo.this.m.getDocumentSrcName())));
                cfg.add(Executor.element((String)Executor.name((String)"currentDocid"), (String)docName));
                cfg.add(Executor.element((String)Executor.name((String)"targetDatabaseDocument"), (String)this.getTargetDatabaseDocument()));
                cfg.add(Executor.element((String)Executor.name((String)"targetDirectory"), (String)(Fo.this.m.path(Fo.this.m.getDocbkxOutputDirectory()) + "/" + Fo.this.getFormat())));
                cfg.add(Executor.element((String)Executor.name((String)"targetsFilename"), (String)(Fo.this.m.getDocumentSrcName() + ".fo.target.db")));
                Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"com.agilejava.docbkx"), (String)Executor.artifactId((String)"docbkx-maven-plugin"), (String)Executor.version((String)Fo.this.m.getDocbkxVersion())), (String)Executor.goal((String)("generate-" + Fo.this.getFormat())), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])cfg.toArray(new MojoExecutor.Element[cfg.size()])), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)Fo.this.m.getProject(), (MavenSession)Fo.this.m.getSession(), (BuildPluginManager)Fo.this.m.getPluginManager()));
                File outputDir = FileUtils.getFile((File)Fo.this.m.getBaseDir(), (String[])new String[]{"target", "docbkx", Fo.this.getFormat(), docName});
                if (!outputDir.exists()) {
                    outputDir = new File(Fo.this.m.getDocbkxOutputDirectory(), Fo.this.getFormat() + File.separator + docName);
                }
                try {
                    String[] extensions = new String[]{"fo", Fo.this.getFormat()};
                    Iterator files = FileUtils.iterateFiles((File)outputDir, (String[])extensions, (boolean)true);
                    while (files.hasNext()) {
                        FileUtils.forceDelete((File)((File)files.next()));
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Cannot delete a file: " + e.getMessage());
                }
            }
        }

        void build() throws MojoExecutionException {
            for (String docName : Fo.this.m.getDocNames()) {
                ArrayList<MojoExecutor.Element> cfg = new ArrayList<MojoExecutor.Element>();
                cfg.addAll(Fo.this.m.getBaseConfiguration());
                cfg.add(Executor.element((String)Executor.name((String)"foCustomization"), (String)Fo.this.m.path(Fo.this.m.getFoCustomization())));
                cfg.add(Executor.element((String)Executor.name((String)"fop1Extensions"), (String)"1"));
                if (Fo.this.getFormat().equalsIgnoreCase("pdf")) {
                    cfg.add(Executor.element((String)Executor.name((String)"insertOlinkPdfFrag"), (String)"1"));
                }
                if (!Fo.this.getFormat().equalsIgnoreCase("rtf")) {
                    cfg.add(Executor.element((String)Executor.name((String)"fopLogLevel"), (String)Fo.this.m.getFopLogLevel()));
                }
                if (!Fo.this.getFormat().equalsIgnoreCase("rtf")) {
                    cfg.add(Executor.element((String)Executor.name((String)"targetDatabaseDocument"), (String)this.getTargetDatabaseDocument()));
                }
                cfg.add(Executor.element((String)Executor.name((String)"targetDirectory"), (String)(Fo.this.m.path(Fo.this.m.getDocbkxOutputDirectory()) + "/" + Fo.this.getFormat())));
                String fontDir = Fo.this.m.path(Fo.this.m.getFontsDirectory());
                cfg.add(Fop.getFontsElement(fontDir));
                cfg.add(Executor.element((String)Executor.name((String)"includes"), (String)(docName + "/" + Fo.this.m.getDocumentSrcName())));
                cfg.add(Executor.element((String)Executor.name((String)"currentDocid"), (String)docName));
                String docbkxVersion = Fo.this.m.getDocbkxVersion();
                if (Fo.this.format.equalsIgnoreCase("rtf")) {
                    docbkxVersion = "2.0.14";
                }
                Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"com.agilejava.docbkx"), (String)Executor.artifactId((String)"docbkx-maven-plugin"), (String)Executor.version((String)docbkxVersion), (List)Executor.dependencies((Dependency[])new Dependency[]{Executor.dependency((String)Executor.groupId((String)"net.sf.offo"), (String)Executor.artifactId((String)"fop-hyph"), (String)Executor.version((String)Fo.this.m.getFopHyphVersion()))})), (String)Executor.goal((String)("generate-" + Fo.this.getFormat())), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])cfg.toArray(new MojoExecutor.Element[cfg.size()])), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)Fo.this.m.getProject(), (MavenSession)Fo.this.m.getSession(), (BuildPluginManager)Fo.this.m.getPluginManager()));
                File file = FileUtils.getFile((File)Fo.this.m.getDocbkxOutputDirectory(), (String[])new String[]{Fo.this.getFormat(), FilenameUtils.getBaseName((String)Fo.this.m.getDocumentSrcName()) + "." + Fo.this.getFormat()});
                try {
                    NameUtils.renameDocument(file, docName, Fo.this.m.getProjectName());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to rename document", (Exception)e);
                }
            }
        }
    }
}

