/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.utils.ImageCopier;
import org.forgerock.doc.maven.utils.NameUtils;
import org.forgerock.doc.maven.utils.OLinkUtils;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class Epub {
    private AbstractDocbkxMojo m;
    private final Executor executor;

    public Epub(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.executor = new Executor();
    }

    public void execute() throws MojoExecutionException {
        this.executor.prepareOlinkDB();
        this.executor.build();
    }

    final String getTargetDB() throws MojoExecutionException {
        File targetDB = new File(this.m.getBuildDirectory(), "olinkdb-epub.xml");
        try {
            OLinkUtils.createTargetDatabase(targetDB, "epub", this.m);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to write link target database: " + targetDB.getPath(), e);
        }
        return targetDB.getPath();
    }

    class Executor
    extends MojoExecutor {
        private String targetDatabaseDocument;

        Executor() {
        }

        String getTargetDatabaseDocument() throws MojoExecutionException {
            if (this.targetDatabaseDocument == null || this.targetDatabaseDocument.isEmpty()) {
                this.targetDatabaseDocument = Epub.this.getTargetDB();
            }
            return this.targetDatabaseDocument;
        }

        void prepareOlinkDB() throws MojoExecutionException {
            for (String docName : Epub.this.m.getDocNames()) {
                ArrayList<MojoExecutor.Element> cfg = new ArrayList<MojoExecutor.Element>();
                cfg.addAll(Epub.this.m.getBaseConfiguration());
                cfg.add(Executor.element((String)Executor.name((String)"xincludeSupported"), (String)Epub.this.m.isXincludeSupported()));
                cfg.add(Executor.element((String)Executor.name((String)"sourceDirectory"), (String)Epub.this.m.path(Epub.this.m.getDocbkxModifiableSourcesDirectory())));
                cfg.add(Executor.element((String)Executor.name((String)"collectXrefTargets"), (String)"yes"));
                cfg.add(Executor.element((String)Executor.name((String)"includes"), (String)(docName + "/" + Epub.this.m.getDocumentSrcName())));
                cfg.add(Executor.element((String)Executor.name((String)"currentDocid"), (String)docName));
                cfg.add(Executor.element((String)Executor.name((String)"targetDatabaseDocument"), (String)this.getTargetDatabaseDocument()));
                cfg.add(Executor.element((String)Executor.name((String)"targetDirectory"), (String)(Epub.this.m.path(Epub.this.m.getDocbkxOutputDirectory()) + "/epub")));
                cfg.add(Executor.element((String)Executor.name((String)"targetsFilename"), (String)(Epub.this.m.getDocumentSrcName() + ".epub.target.db")));
                Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"com.agilejava.docbkx"), (String)Executor.artifactId((String)"docbkx-maven-plugin"), (String)Executor.version((String)Epub.this.m.getDocbkxVersion())), (String)Executor.goal((String)"generate-epub"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])cfg.toArray(new MojoExecutor.Element[cfg.size()])), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)Epub.this.m.getProject(), (MavenSession)Epub.this.m.getSession(), (BuildPluginManager)Epub.this.m.getPluginManager()));
            }
        }

        void build() throws MojoExecutionException {
            try {
                ImageCopier.copyImages("epub", "", Epub.this.m);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy images", (Exception)e);
            }
            for (String docName : Epub.this.m.getDocNames()) {
                ArrayList<MojoExecutor.Element> cfg = new ArrayList<MojoExecutor.Element>();
                cfg.addAll(Epub.this.m.getBaseConfiguration());
                cfg.add(Executor.element((String)Executor.name((String)"epubCustomization"), (String)Epub.this.m.path(Epub.this.m.getEpubCustomization())));
                cfg.add(Executor.element((String)Executor.name((String)"targetDatabaseDocument"), (String)this.getTargetDatabaseDocument()));
                cfg.add(Executor.element((String)Executor.name((String)"targetDirectory"), (String)(Epub.this.m.path(Epub.this.m.getDocbkxOutputDirectory()) + "/epub")));
                cfg.add(Executor.element((String)Executor.name((String)"includes"), (String)(docName + "/" + Epub.this.m.getDocumentSrcName())));
                Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"com.agilejava.docbkx"), (String)Executor.artifactId((String)"docbkx-maven-plugin"), (String)Executor.version((String)Epub.this.m.getDocbkxVersion())), (String)Executor.goal((String)"generate-epub"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])cfg.toArray(new MojoExecutor.Element[cfg.size()])), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)Epub.this.m.getProject(), (MavenSession)Epub.this.m.getSession(), (BuildPluginManager)Epub.this.m.getPluginManager()));
                File outputEpub = FileUtils.getFile((File)Epub.this.m.getDocbkxOutputDirectory(), (String[])new String[]{"epub", FilenameUtils.getBaseName((String)Epub.this.m.getDocumentSrcName()) + ".epub"});
                try {
                    NameUtils.renameDocument(outputEpub, docName, Epub.this.m.getProjectName());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to rename document", (Exception)e);
                }
            }
        }
    }
}

