/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.utils.ImageCopier;
import org.forgerock.doc.maven.utils.OLinkUtils;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class ChunkedHtml {
    private AbstractDocbkxMojo m;
    private final Executor executor;

    public ChunkedHtml(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.executor = new Executor();
    }

    public void execute() throws MojoExecutionException {
        this.executor.prepareOlinkDB();
        this.executor.build();
    }

    final String getTargetDB() throws MojoExecutionException {
        File targetDB = new File(this.m.getBuildDirectory(), "olinkdb-chunked-html.xml");
        try {
            OLinkUtils.createTargetDatabase(targetDB, "html", this.m, true);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to write link target database: " + targetDB.getPath(), e);
        }
        return targetDB.getPath();
    }

    class Executor
    extends MojoExecutor {
        Executor() {
        }

        void prepareOlinkDB() throws MojoExecutionException {
            for (String docName : ChunkedHtml.this.m.getDocNames()) {
                ArrayList<MojoExecutor.Element> cfg = new ArrayList<MojoExecutor.Element>();
                cfg.add(Executor.element((String)Executor.name((String)"xincludeSupported"), (String)ChunkedHtml.this.m.isXincludeSupported()));
                cfg.add(Executor.element((String)Executor.name((String)"sourceDirectory"), (String)ChunkedHtml.this.m.path(ChunkedHtml.this.m.getDocbkxModifiableSourcesDirectory())));
                cfg.add(Executor.element((String)Executor.name((String)"chunkedOutput"), (String)"true"));
                cfg.add(Executor.element((String)Executor.name((String)"htmlCustomization"), (String)ChunkedHtml.this.m.path(ChunkedHtml.this.m.getChunkedHTMLCustomization())));
                cfg.add(Executor.element((String)Executor.name((String)"collectXrefTargets"), (String)"only"));
                cfg.add(Executor.element((String)Executor.name((String)"currentDocid"), (String)docName));
                cfg.add(Executor.element((String)Executor.name((String)"includes"), (String)(docName + "/" + ChunkedHtml.this.m.getDocumentSrcName())));
                cfg.add(Executor.element((String)Executor.name((String)"targetDirectory"), (String)(ChunkedHtml.this.m.path(ChunkedHtml.this.m.getDocbkxOutputDirectory()) + "/html")));
                cfg.add(Executor.element((String)Executor.name((String)"targetsFilename"), (String)(ChunkedHtml.this.m.getDocumentSrcName() + ".html.target.db")));
                String base = FilenameUtils.getBaseName((String)ChunkedHtml.this.m.getDocumentSrcName());
                String chunkBaseDir = ChunkedHtml.this.m.path(ChunkedHtml.this.m.getDocbkxOutputDirectory()) + "/html/" + docName + "/" + base + "/";
                Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"com.agilejava.docbkx"), (String)Executor.artifactId((String)"docbkx-maven-plugin"), (String)Executor.version((String)ChunkedHtml.this.m.getDocbkxVersion())), (String)Executor.goal((String)"generate-html"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])cfg.toArray(new MojoExecutor.Element[cfg.size()])), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)ChunkedHtml.this.m.getProject(), (MavenSession)ChunkedHtml.this.m.getSession(), (BuildPluginManager)ChunkedHtml.this.m.getPluginManager()));
            }
        }

        void build() throws MojoExecutionException {
            String documentSrcName = FilenameUtils.getBaseName((String)ChunkedHtml.this.m.getDocumentSrcName());
            try {
                ImageCopier.copyImages("html", documentSrcName, ChunkedHtml.this.m);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy images", (Exception)e);
            }
            for (String docName : ChunkedHtml.this.m.getDocNames()) {
                ArrayList<MojoExecutor.Element> cfg = new ArrayList<MojoExecutor.Element>();
                cfg.addAll(ChunkedHtml.this.m.getBaseConfiguration());
                cfg.add(Executor.element((String)Executor.name((String)"chunkedOutput"), (String)"true"));
                cfg.add(Executor.element((String)Executor.name((String)"htmlCustomization"), (String)ChunkedHtml.this.m.path(ChunkedHtml.this.m.getChunkedHTMLCustomization())));
                cfg.add(Executor.element((String)Executor.name((String)"targetDatabaseDocument"), (String)ChunkedHtml.this.getTargetDB()));
                cfg.add(Executor.element((String)Executor.name((String)"generateManifest"), (String)"1"));
                cfg.add(Executor.element((String)Executor.name((String)"includes"), (String)(docName + "/" + ChunkedHtml.this.m.getDocumentSrcName())));
                String base = FilenameUtils.getBaseName((String)ChunkedHtml.this.m.getDocumentSrcName());
                String chunkBaseDir = ChunkedHtml.this.m.path(ChunkedHtml.this.m.getDocbkxOutputDirectory()) + "/html/" + docName + "/" + base + "/";
                cfg.add(Executor.element((String)Executor.name((String)"manifest"), (String)(ChunkedHtml.this.m.getDocbkxOutputDirectory().getPath() + "/" + docName + ".manifest")));
                Executor.executeMojo((Plugin)Executor.plugin((String)Executor.groupId((String)"com.agilejava.docbkx"), (String)Executor.artifactId((String)"docbkx-maven-plugin"), (String)Executor.version((String)ChunkedHtml.this.m.getDocbkxVersion())), (String)Executor.goal((String)"generate-html"), (Xpp3Dom)Executor.configuration((MojoExecutor.Element[])cfg.toArray(new MojoExecutor.Element[cfg.size()])), (MojoExecutor.ExecutionEnvironment)Executor.executionEnvironment((MavenProject)ChunkedHtml.this.m.getProject(), (MavenSession)ChunkedHtml.this.m.getSession(), (BuildPluginManager)ChunkedHtml.this.m.getPluginManager()));
            }
        }
    }
}

