/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.backstage;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.utils.NameUtils;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class Pdf {
    private AbstractDocbkxMojo m;

    public Pdf(AbstractDocbkxMojo mojo) {
        this.m = mojo;
    }

    public void execute() throws MojoExecutionException {
        this.copyPdfFiles();
        this.renamePdfFiles();
    }

    private void copyPdfFiles() throws MojoExecutionException {
        if (!this.m.getFormats().contains((Object)AbstractDocbkxMojo.Format.pdf)) {
            StringBuilder formatList = new StringBuilder();
            for (AbstractDocbkxMojo.Format format : this.m.getFormats()) {
                formatList.append(format.toString()).append(' ');
            }
            throw new MojoExecutionException("PDF format documents are required yet not available." + System.getProperty("line.separator") + " Available formats include: " + formatList.toString() + System.getProperty("line.separator") + "You can use -Dformats=pdf to build PDF format documents.");
        }
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)this.m.getMavenResourcesVersion())), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"encoding"), (String)"UTF-8"), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)this.m.path(this.m.getBackstageDirectory())), MojoExecutor.element((String)"resources", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)this.m.path(this.m.getDocbkxOutputDirectory())), MojoExecutor.element((String)"includes", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"include", (String)"**/*.pdf")})})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.m.getProject(), (MavenSession)this.m.getSession(), (BuildPluginManager)this.m.getPluginManager()));
    }

    private void renamePdfFiles() throws MojoExecutionException {
        String[] ext = new String[]{"pdf"};
        File pdfDirectory = new File(this.m.getBackstageDirectory(), "pdf");
        for (File pdf : FileUtils.listFiles((File)pdfDirectory, (String[])ext, (boolean)false)) {
            String docName = pdf.getName().replaceFirst(this.m.getProjectName() + "-", "").replaceFirst(".pdf", "");
            String newName = NameUtils.renameDoc(this.m.getBackstageProductName(), docName, this.m.getProjectVersion(), "pdf");
            if (pdf.renameTo(new File(pdf.getParent(), newName))) continue;
            throw new MojoExecutionException("Failed to rename PDF: " + newName);
        }
    }
}

