/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven.backstage;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.backstage.ArtifactItem;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class ArtifactDocs {
    private AbstractDocbkxMojo m;
    private File baseDirectory;

    public ArtifactDocs(AbstractDocbkxMojo mojo) {
        this.m = mojo;
        this.baseDirectory = new File(this.m.getBackstageDirectory(), "apidocs");
    }

    public void execute() throws MojoExecutionException {
        for (ArtifactItem artifactItem : this.m.getArtifactItems()) {
            File outputDirectory = new File(this.baseDirectory, artifactItem.getOutputDirectory());
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)this.m.getMavenDependencyVersion())), (String)MojoExecutor.goal((String)"unpack"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"artifactItems", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"artifactItem", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"groupId", (String)artifactItem.getGroupId()), MojoExecutor.element((String)"artifactId", (String)artifactItem.getArtifactId()), MojoExecutor.element((String)"version", (String)artifactItem.getVersion()), MojoExecutor.element((String)"type", (String)artifactItem.getType()), MojoExecutor.element((String)"classifier", (String)artifactItem.getClassifier()), MojoExecutor.element((String)"overWrite", (String)"true"), MojoExecutor.element((String)"outputDirectory", (String)outputDirectory.getPath()), MojoExecutor.element((String)"includes", (String)"**/*.*")})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.m.getProject(), (MavenSession)this.m.getSession(), (BuildPluginManager)this.m.getPluginManager()));
            this.writeDocsetJson(artifactItem.getTitle(), outputDirectory);
        }
    }

    private void writeDocsetJson(String title, File directory) throws MojoExecutionException {
        if (title == null || title.isEmpty()) {
            throw new MojoExecutionException("Document title must be set for the artifact.");
        }
        String json = "{\"title\":\"" + title + "\"}";
        File file = new File(directory, "meta.json");
        try {
            FileUtils.writeStringToFile((File)file, (String)json);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write :" + file.getPath());
        }
    }
}

