/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.pre.ArtifactBuilder;
import org.forgerock.doc.maven.pre.AsciidocToDocBook;
import org.forgerock.doc.maven.pre.Branding;
import org.forgerock.doc.maven.pre.CommonContent;
import org.forgerock.doc.maven.pre.ConditionalText;
import org.forgerock.doc.maven.pre.CreateThumbs;
import org.forgerock.doc.maven.pre.CurrentDocId;
import org.forgerock.doc.maven.pre.CustomCss;
import org.forgerock.doc.maven.pre.Dpi;
import org.forgerock.doc.maven.pre.Filter;
import org.forgerock.doc.maven.pre.HeaderColor;
import org.forgerock.doc.maven.pre.ImageData;
import org.forgerock.doc.maven.pre.JCite;
import org.forgerock.doc.maven.pre.KeepTogether;
import org.forgerock.doc.maven.pre.ModifiableCopy;
import org.forgerock.doc.maven.pre.PlantUml;
import org.forgerock.doc.maven.pre.XCite;

@Mojo(name="process", defaultPhase=LifecyclePhase.PRE_SITE)
public class PreProcessMojo
extends AbstractDocbkxMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getBuildDirectory() == null) {
            throw new MojoExecutionException("No build directory available.");
        }
        if (!this.getBuildDirectory().exists() && !this.getBuildDirectory().mkdir()) {
            throw new MojoExecutionException("Could not create build directory");
        }
        new Branding(this).execute();
        new ModifiableCopy(this).execute();
        new ConditionalText(this).execute();
        if (!this.doUsePreProcessedSources()) {
            new CommonContent(this).execute();
            new AsciidocToDocBook(this).execute();
            new JCite(this).execute();
            new XCite(this).execute();
            new Filter(this).execute();
            new ImageData(this).execute();
            new HeaderColor(this).execute();
            new PlantUml(this).execute();
            if (this.getFormats().contains((Object)AbstractDocbkxMojo.Format.pdf) || this.getFormats().contains((Object)AbstractDocbkxMojo.Format.rtf)) {
                new KeepTogether(this).execute();
                new Dpi(this).execute();
            }
            if (this.getFormats().contains((Object)AbstractDocbkxMojo.Format.bootstrap)) {
                new CreateThumbs(this).execute();
            }
            new CurrentDocId(this).execute();
            new CustomCss(this).execute();
        }
        if (this.doCreateArtifacts()) {
            new ArtifactBuilder(this).execute();
        }
    }
}

