/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.forgerock.doc.maven.AbstractDocbkxMojo;
import org.forgerock.doc.maven.backstage.ArtifactDocs;
import org.forgerock.doc.maven.backstage.Pdf;
import org.forgerock.json.fluent.JsonValue;

@Mojo(name="backstage", defaultPhase=LifecyclePhase.SITE)
public class BackstageMojo
extends AbstractDocbkxMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getBackstageProductName().isEmpty()) {
            throw new MojoFailureException("You must set backstageProductName.");
        }
        new ArtifactDocs(this).execute();
        File docbookDirectory = new File(this.getBackstageDirectory(), "docbook");
        try {
            FileUtils.copyDirectory((File)this.getDocbkxModifiableSourcesDirectory(), (File)docbookDirectory, (FileFilter)FileFilterUtils.trueFileFilter());
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to copy pre-processed sources.", (Throwable)e);
        }
        this.writeDocsetJson();
        new Pdf(this).execute();
    }

    private void writeDocsetJson() throws MojoFailureException {
        JsonValue jsonValue = new JsonValue(new LinkedHashMap()).add("product", (Object)this.getBackstageProductName()).add("version", (Object)this.getProjectVersion()).add("language", (Object)this.getLocaleTag()).add("released", (Object)this.getReleaseDate());
        File file = new File(this.getBackstageDirectory(), "docset.json");
        try {
            FileUtils.writeStringToFile((File)file, (String)jsonValue.toString());
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to write :" + file.getPath());
        }
    }
}

