/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.doc.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.forgerock.doc.maven.backstage.ArtifactItem;
import org.forgerock.doc.maven.utils.NameUtils;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractDocbkxMojo
extends AbstractMojo {
    private Properties versions;
    private String ansi = "false";
    private String areSectionsAutolabeled = "true";
    @Parameter(defaultValue="${basedir}/src/main/asciidoc")
    private File asciidocSourceDirectory;
    @Parameter
    private String asciidoctorPluginVersion;
    @Parameter(defaultValue="backstage")
    private String backstageDirectory;
    @Parameter(property="backstageProductName")
    private String backstageProductName;
    @Parameter(defaultValue="${basedir}")
    private File baseDir;
    @Parameter(defaultValue="doc-default-branding")
    private String brandingArtifactId;
    @Parameter(defaultValue="org.openidentityplatform.commons")
    private String brandingGroupId;
    @Parameter
    private String brandingVersion;
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDirectory;
    @Parameter(defaultValue="false", property="buildReleaseZip")
    private boolean buildReleaseZip;
    private String chunkedHTMLCustomization = "docbkx-stylesheets/html/chunked.xsl";
    @Parameter(defaultValue="doc-common-content")
    private String commonContentArtifactId;
    @Parameter(defaultValue="org.openidentityplatform.commons")
    private String commonContentGroupId;
    @Parameter
    private String commonContentVersion;
    @Parameter(defaultValue="false")
    private boolean copyResourceFiles;
    @Parameter(defaultValue="true")
    private boolean createArtifacts;
    @Parameter
    private List<ArtifactItem> artifactItems;
    private String docbkxModifiableSourcesDirectory = "docbkx-sources";
    private String docbkxOutputDirectory = "docbkx";
    @Parameter(defaultValue="${basedir}/src/main/docbkx", property="docbkxSourceDirectory")
    private File docbkxSourceDirectory;
    @Parameter
    private String docbkxVersion;
    @Parameter
    private Map<String, String> inclusions;
    @Parameter
    private Map<String, String> exclusions;
    @Parameter(defaultValue="http://docs.forgerock.org/")
    private String docsSite;
    @Parameter(defaultValue="index.xml", property="documentSrcName")
    private String documentSrcName;
    private String doesSectionLabelIncludeComponentLabel = "true";
    @Parameter(defaultValue="http://docbook.sourceforge.net/release/images/draft.png")
    private String draftWatermarkURL;
    @Parameter(defaultValue="http://docs.forgerock.org/eosl.json")
    private String eoslJson;
    private String epubCustomization = "docbkx-stylesheets/epub/coredoc.xsl";
    @Parameter(defaultValue="<link rel=\"shortcut icon\" href=\"https://assets-cdn.github.com/favicon.ico\">")
    private String faviconLink;
    private String foCustomization = "docbkx-stylesheets/fo/coredoc.xsl";
    private String fontsDirectory = "fonts";
    @Parameter
    private String fopHyphVersion;
    @Parameter(defaultValue="ERROR")
    private String fopLogLevel;
    @Parameter(property="formats", defaultValue="bootstrap,pdf")
    private List<Format> formats;
    @Parameter(defaultValue="")
    private String googleAnalyticsId;
    @Parameter(defaultValue="yes", property="isDraftMode")
    private String isDraftMode;
    private String isXincludeSupported = "true";
    private String javaScriptFileName = "uses-jquery.js";
    @Parameter
    private List<File> jCiteSourcePaths;
    @Parameter
    private String jCiteVersion;
    @Parameter(defaultValue="false")
    private boolean keepCustomIndexHtml;
    @Parameter(defaultValue="http://docs.forgerock.org/latest.json")
    private String latestJson;
    @Parameter
    private String linkTesterVersion;
    @Parameter(defaultValue="en")
    private String localeTag;
    private String manpagesCustomization = "docbkx-stylesheets/man/coredoc.xsl";
    @Parameter
    private String mavenAssemblyVersion;
    @Parameter
    private String mavenDependencyVersion;
    @Parameter
    private String mavenFilteringVersion;
    @Parameter
    private String mavenResourcesVersion;
    @Parameter(defaultValue="5")
    private int maxImageHeightInInches;
    @Parameter(defaultValue="true")
    private boolean overwriteModifiableCopy;
    @Parameter(defaultValue="true", property="overwriteProjectFilesWithSharedContent")
    private boolean overwriteProjectFilesWithSharedContent;
    @Parameter
    private String plantUmlVersion;
    @Parameter
    private String plexusUtilsVersion;
    @Component
    private BuildPluginManager pluginManager;
    private String preSiteCssFileName = "coredoc.css";
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="projectName", required=true)
    private String projectName;
    @Parameter(property="projectVersion", required=true)
    private String projectVersion;
    private String releaseCssFileName = "dfo.css";
    @Parameter(property="releaseDate")
    private String releaseDate;
    @Parameter(defaultValue="release")
    private String releaseDirectory;
    @Parameter(defaultValue="<link rel=\"shortcut icon\" href=\"https://assets-cdn.github.com/favicon.ico\">")
    private String releaseFaviconLink;
    @Parameter(property="releaseVersion", required=true)
    private String releaseVersion;
    @Parameter(defaultValue="resources")
    private String resourcesDirectory;
    @Parameter(defaultValue="true", property="runLinkTester")
    private String runLinkTester;
    @Parameter(property="session", required=true, readonly=true)
    private MavenSession session;
    private String singleHTMLCustomization = "/docbkx-stylesheets/html/coredoc.xsl";
    @Parameter(defaultValue="site")
    private String siteDirectory;
    @Parameter(defaultValue="false", property="skipLinkCheck")
    private String skipLinkCheck;
    @Parameter
    private String[] skipUrlPatterns;
    @Parameter(defaultValue="false", property="usePreProcessedSources")
    private boolean usePreProcessedSources;
    private String useSyntaxHighlighting = "1";
    private String webhelpCss = "docbkx-stylesheets/webhelp/positioning.css";
    private String webhelpCustomization = "docbkx-stylesheets/webhelp/coredoc.xsl";
    private String webhelpLogo = "docbkx-stylesheets/webhelp/logo.png";
    @Parameter
    private String xCiteVersion;
    private String xhtml5Customization = "docbkx-stylesheets/xhtml5/coredoc.xsl";
    private String bootstrapCustomization = "docbkx-stylesheets/bootstrap/coredoc.xsl";

    private void loadVersions() {
        this.versions = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/versions.properties");
            if (inputStream == null) {
                throw new IOException("Could not read properties resource");
            }
            this.versions.load(inputStream);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Failed to read plugin version properties", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getVersionProperty(String currentValue, String key) {
        if (currentValue != null && !currentValue.isEmpty()) {
            return currentValue;
        }
        if (this.versions == null) {
            this.loadVersions();
        }
        return this.versions.getProperty(key);
    }

    public final String useAnsi() {
        return this.ansi;
    }

    public final String areSectionsAutolabeled() {
        return this.areSectionsAutolabeled;
    }

    public File getAsciidocSourceDirectory() {
        return this.asciidocSourceDirectory;
    }

    public String getAsciidoctorPluginVersion() {
        return this.getVersionProperty(this.asciidoctorPluginVersion, "asciidoctorPluginVersion");
    }

    public File getBackstageDirectory() {
        return new File(this.getBuildDirectory(), this.backstageDirectory);
    }

    public String getBackstageProductName() {
        return this.backstageProductName != null ? this.backstageProductName : this.projectName;
    }

    public ArrayList<MojoExecutor.Element> getBaseConfiguration() {
        ArrayList<MojoExecutor.Element> cfg = new ArrayList<MojoExecutor.Element>();
        cfg.add(MojoExecutor.element((String)MojoExecutor.name((String)"draftMode"), (String)this.isDraftMode()));
        cfg.add(MojoExecutor.element((String)MojoExecutor.name((String)"draftWatermarkImage"), (String)this.getDraftWatermarkURL()));
        cfg.add(MojoExecutor.element((String)MojoExecutor.name((String)"highlightSource"), (String)this.useSyntaxHighlighting()));
        cfg.add(MojoExecutor.element((String)MojoExecutor.name((String)"sectionAutolabel"), (String)this.areSectionsAutolabeled()));
        cfg.add(MojoExecutor.element((String)MojoExecutor.name((String)"sectionLabelIncludesComponentLabel"), (String)this.doesSectionLabelIncludeComponentLabel()));
        cfg.add(MojoExecutor.element((String)MojoExecutor.name((String)"xincludeSupported"), (String)this.isXincludeSupported()));
        cfg.add(MojoExecutor.element((String)MojoExecutor.name((String)"sourceDirectory"), (String)this.path(this.getDocbkxModifiableSourcesDirectory())));
        return cfg;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public String getBrandingArtifactId() {
        return this.brandingArtifactId;
    }

    public String getBrandingGroupId() {
        return this.brandingGroupId;
    }

    public String getBrandingVersion() {
        return this.getVersionProperty(this.brandingVersion, "brandingVersion");
    }

    public File getBuildDirectory() {
        return this.buildDirectory;
    }

    public final boolean doBuildReleaseZip() {
        return this.buildReleaseZip;
    }

    public final File getChunkedHTMLCustomization() {
        return new File(this.getBuildDirectory(), this.chunkedHTMLCustomization);
    }

    public String getCommonContentArtifactId() {
        return this.commonContentArtifactId;
    }

    public String getCommonContentGroupId() {
        return this.commonContentGroupId;
    }

    public String getCommonContentVersion() {
        return this.getVersionProperty(this.commonContentVersion, "commonContentVersion");
    }

    public boolean doCopyResourceFiles() {
        return this.copyResourceFiles;
    }

    public boolean doCreateArtifacts() {
        return this.createArtifacts;
    }

    public List<ArtifactItem> getArtifactItems() {
        return this.artifactItems != null ? this.artifactItems : new LinkedList<ArtifactItem>();
    }

    public File getDocbkxModifiableSourcesDirectory() {
        return new File(this.getBuildDirectory(), this.docbkxModifiableSourcesDirectory);
    }

    public File getDocbkxOutputDirectory() {
        return new File(this.buildDirectory, this.docbkxOutputDirectory);
    }

    public File getDocbkxSourceDirectory() {
        return this.docbkxSourceDirectory;
    }

    public String getDocbkxVersion() {
        return this.getVersionProperty(this.docbkxVersion, "docbkxVersion");
    }

    private boolean isProfileAttribute(String attribute) {
        try {
            ProfileAttributes.valueOf(attribute);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public Map<String, String> getInclusions() {
        if (this.inclusions == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String attribute : this.inclusions.keySet()) {
            if (!this.isProfileAttribute(attribute)) continue;
            result.put(attribute, this.inclusions.get(attribute));
        }
        return result;
    }

    public Map<String, String> getExclusions() {
        if (this.exclusions == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String attribute : this.exclusions.keySet()) {
            if (!this.isProfileAttribute(attribute)) continue;
            result.put(attribute, this.exclusions.get(attribute));
        }
        return result;
    }

    public Set<String> getDocNames() throws MojoExecutionException {
        Set<String> docNames = NameUtils.getDocumentNames(this.getDocbkxModifiableSourcesDirectory(), this.getDocumentSrcName());
        if (docNames.isEmpty()) {
            throw new MojoExecutionException("No document names found.");
        }
        return docNames;
    }

    public String getDocsSite() {
        return this.docsSite;
    }

    public String getDocumentSrcName() {
        return this.documentSrcName;
    }

    public final String doesSectionLabelIncludeComponentLabel() {
        return this.doesSectionLabelIncludeComponentLabel;
    }

    public final String getDraftWatermarkURL() {
        return this.draftWatermarkURL;
    }

    public String getEoslJson() {
        return this.eoslJson;
    }

    public final File getEpubCustomization() {
        return new File(this.getBuildDirectory(), this.epubCustomization);
    }

    public final String getFaviconLink() {
        return this.faviconLink;
    }

    public final File getFoCustomization() {
        return new File(this.getBuildDirectory(), this.foCustomization);
    }

    public final File getFontsDirectory() {
        return new File(this.getBuildDirectory(), this.fontsDirectory);
    }

    public String getFopHyphVersion() {
        return this.getVersionProperty(this.fopHyphVersion, "fopHyphVersion");
    }

    public final String getFopLogLevel() {
        return this.fopLogLevel;
    }

    public List<Format> getFormats() {
        return this.formats;
    }

    public String getGoogleAnalyticsId() {
        return this.googleAnalyticsId;
    }

    public final String isDraftMode() {
        return this.isDraftMode;
    }

    public final String isXincludeSupported() {
        return this.isXincludeSupported;
    }

    public String getJavaScriptFileName() {
        return this.javaScriptFileName;
    }

    public List<File> getJCiteSourcePaths() {
        return this.jCiteSourcePaths;
    }

    public String getJCiteVersion() {
        return this.getVersionProperty(this.jCiteVersion, "jCiteVersion");
    }

    public boolean keepCustomIndexHtml() {
        return this.keepCustomIndexHtml;
    }

    public String getLatestJson() {
        return this.latestJson;
    }

    public String getLinkTesterVersion() {
        return this.getVersionProperty(this.linkTesterVersion, "linkTesterVersion");
    }

    public String getLocaleTag() {
        return this.localeTag;
    }

    public final File getManpagesCustomization() {
        return new File(this.getBuildDirectory(), this.manpagesCustomization);
    }

    public String getMavenAssemblyVersion() {
        return this.getVersionProperty(this.mavenAssemblyVersion, "mavenAssemblyVersion");
    }

    public String getMavenDependencyVersion() {
        return this.getVersionProperty(this.mavenDependencyVersion, "mavenDependencyVersion");
    }

    public String getMavenFilteringVersion() {
        return this.getVersionProperty(this.mavenFilteringVersion, "mavenFilteringVersion");
    }

    public String getMavenResourcesVersion() {
        return this.getVersionProperty(this.mavenResourcesVersion, "mavenResourcesVersion");
    }

    public int getMaxImageHeightInInches() {
        return this.maxImageHeightInInches;
    }

    public boolean doOverwriteModifiableCopy() {
        return this.overwriteModifiableCopy;
    }

    public boolean doOverwriteProjectFilesWithSharedContent() {
        return this.overwriteProjectFilesWithSharedContent;
    }

    public String path(File file) {
        String result = "";
        if (file != null) {
            result = FilenameUtils.separatorsToUnix((String)file.getPath());
        }
        return result;
    }

    public String getPlantUmlVersion() {
        return this.getVersionProperty(this.plantUmlVersion, "plantUmlVersion");
    }

    public String getPlexusUtilsVersion() {
        return this.getVersionProperty(this.plexusUtilsVersion, "plexusUtilsVersion");
    }

    public BuildPluginManager getPluginManager() {
        return this.pluginManager;
    }

    public final File getPreSiteCss() {
        return new File(this.getBuildDirectory(), this.preSiteCssFileName);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public final File getReleaseCss() {
        return new File(this.getBuildDirectory(), this.releaseCssFileName);
    }

    public String getReleaseDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return this.releaseDate == null || this.releaseDate.isEmpty() ? format.format(new Date()) : this.releaseDate;
    }

    public final File getReleaseDirectory() {
        return new File(this.getBuildDirectory(), this.releaseDirectory);
    }

    public final String getReleaseFaviconLink() {
        return this.releaseFaviconLink;
    }

    public final String getReleaseVersion() {
        return this.releaseVersion;
    }

    public final String getReleaseVersionPath() {
        return this.getReleaseDirectory().getPath() + File.separator + this.getProjectName().toLowerCase() + "-" + this.getReleaseVersion() + "-docs";
    }

    public String getRelativeResourcesDirectoryPath() {
        return this.resourcesDirectory;
    }

    public File getResourcesDirectory() {
        return new File(this.getDocbkxModifiableSourcesDirectory(), this.resourcesDirectory);
    }

    public String runLinkTester() {
        return this.runLinkTester;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public final File getSingleHTMLCustomization() {
        return new File(this.getBuildDirectory(), this.singleHTMLCustomization);
    }

    public final File getSiteDirectory() {
        return new File(this.getBuildDirectory(), this.siteDirectory);
    }

    public String skipLinkCheck() {
        return this.skipLinkCheck;
    }

    public String[] getSkipUrlPatterns() {
        return this.skipUrlPatterns;
    }

    public boolean doUsePreProcessedSources() {
        return this.usePreProcessedSources;
    }

    public final String useSyntaxHighlighting() {
        return this.useSyntaxHighlighting;
    }

    public final File getWebHelpCss() {
        return new File(this.getBuildDirectory(), this.webhelpCss);
    }

    public final File getWebHelpCustomization() {
        return new File(this.getBuildDirectory(), this.webhelpCustomization);
    }

    public final File getWebHelpLogo() {
        return new File(this.getBuildDirectory(), this.webhelpLogo);
    }

    public String getXCiteVersion() {
        return this.getVersionProperty(this.xCiteVersion, "xCiteVersion");
    }

    public final File getXhtml5Customization() {
        return new File(this.getBuildDirectory(), this.xhtml5Customization);
    }

    public final File getBootstrapCustomization() {
        return new File(this.getBuildDirectory(), this.bootstrapCustomization);
    }

    public static enum Format {
        epub,
        html,
        bootstrap,
        man,
        pdf,
        rtf,
        webhelp,
        xhtml5;

    }

    public static enum ProfileAttributes {
        arch,
        audience,
        condition,
        conformance,
        lang,
        os,
        revision,
        revisionflag,
        role,
        security,
        status,
        userlevel,
        vendor,
        wordsize;

    }
}

