/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.util;

import de.java2html.util.RGB;
import java.util.Hashtable;

public class HTMLTools {
    protected static Hashtable entityTableEncode;
    protected static final String[] ENTITIES;

    static {
        ENTITIES = new String[]{" ", " ", "-", "-", "'", "'", "`", "`", "&Uuml;", "\u00dc", "&Auml;", "\u00c4", "&Ouml;", "\u00d6", "&Euml;", "\u00cb", "&Ccedil;", "\u00c7", "&AElig;", "\u00c6", "&Aring;", "\u00c5", "&Oslash;", "\u00d8", "&uuml;", "\u00fc", "&auml;", "\u00e4", "&ouml;", "\u00f6", "&euml;", "\u00eb", "&ccedil;", "\u00e7", "&aring;", "\u00e5", "&oslash;", "\u00f8", "&grave;", "`", "&agrave;", "\u00e0", "&egrave;", "\u00e8", "&igrave;", "\u00ec", "&ograve;", "\u00f2", "&ugrave;", "\u00f9", "&amp;", "&", "&#34;", "\"", "&szlig;", "\u00df", "&nbsp;", " ", "&gt;", ">", "&lt;", "<", "&copy;", "(C)", "&cent;", "\u00a2", "&pound;", "\u00a3", "&laquo;", "\u00ab", "&raquo;", "\u00bb", "&reg;", "(R)", "&middot;", " - ", "&times;", " x ", "&acute;", "'", "&aacute;", "\u00e1", "&uacute;", "\u00fa", "&oacute;", "\u00f3", "&eacute;", "\u00e9", "&iacute;", "\u00ed", "&ntilde;", "\u00f1", "&sect;", "\u00a7", "&egrave;", "\u00e8", "&icirc;", "\u00ee", "&ocirc;", "\u00f4", "&acirc;", "\u00e2", "&ucirc;", "\u00fb", "&ecirc;", "\u00ea", "&aelig;", "\u00e6", "&iexcl;", "\u00a1", "&#151;", "-", "&#0151;", "-", "&#0146;", "'", "&#146;", "'", "&#0145;", "'", "&#145;", "'", "&quot;", "\""};
    }

    private HTMLTools() {
    }

    protected static void buildEntityTables() {
        entityTableEncode = new Hashtable(ENTITIES.length);
        int i = 0;
        while (i < ENTITIES.length) {
            if (!entityTableEncode.containsKey(ENTITIES[i + 1])) {
                entityTableEncode.put(ENTITIES[i + 1], ENTITIES[i]);
            }
            i += 2;
        }
    }

    public static final String encode(String s, String ignore) {
        return HTMLTools.encode(s, 0, s.length(), ignore);
    }

    public static final String encode(String s, int start, int end, String ignore) {
        if (entityTableEncode == null) {
            HTMLTools.buildEntityTables();
        }
        StringBuffer sb = new StringBuffer((end - start) * 2);
        int i = start;
        while (i < end) {
            char ch = s.charAt(i);
            if (ch >= '?' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ignore.indexOf(ch) != -1) {
                sb.append(ch);
            } else {
                sb.append(HTMLTools.encodeSingleChar(String.valueOf(ch)));
            }
            ++i;
        }
        return sb.toString();
    }

    protected static final String encodeSingleChar(String ch) {
        String s = (String)entityTableEncode.get(ch);
        return s == null ? ch : s;
    }

    public static final String toHTML(RGB color) {
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        if (red.length() == 1) {
            red = "0" + red;
        }
        if (green.length() == 1) {
            green = "0" + green;
        }
        if (blue.length() == 1) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }
}

