/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.options;

import de.java2html.javasource.JavaSourceType;
import de.java2html.options.JavaSourceStyleEntry;
import de.java2html.util.RGB;
import java.util.Enumeration;
import java.util.Hashtable;

public class JavaSourceStyleTable {
    private Hashtable table;
    private static JavaSourceStyleEntry defaultColorEntry = new JavaSourceStyleEntry(RGB.BLACK);
    private String name;

    private JavaSourceStyleTable(String name) {
        this.setName(name);
        this.table = new Hashtable();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JavaSourceStyleTable)) {
            return false;
        }
        JavaSourceStyleTable other = (JavaSourceStyleTable)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (other.table.size() != this.table.size()) {
            return false;
        }
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            JavaSourceStyleEntry value = this.get(key);
            if (value.equals(other.table.get(key))) continue;
            return false;
        }
        return true;
    }

    public JavaSourceStyleTable getClone() {
        JavaSourceStyleTable clone = new JavaSourceStyleTable(this.getName());
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            JavaSourceStyleEntry value = this.get(key);
            clone.table.put(key, value);
        }
        return clone;
    }

    public static JavaSourceStyleTable[] getPredefinedTables() {
        return new JavaSourceStyleTable[]{JavaSourceStyleTable.createDefaultEclipseStyleTable(), JavaSourceStyleTable.createDefaultKawaStyleTable(), JavaSourceStyleTable.createDefaultMonochromeStyleTable()};
    }

    public static JavaSourceStyleTable getPredefinedTable(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null.");
        }
        JavaSourceStyleTable[] tables = JavaSourceStyleTable.getPredefinedTables();
        int i = 0;
        while (i < tables.length) {
            if (tables[i].getName().equalsIgnoreCase(name)) {
                return tables[i];
            }
            ++i;
        }
        return null;
    }

    private static JavaSourceStyleTable createDefaultKawaStyleTable() {
        JavaSourceStyleTable table = new JavaSourceStyleTable("Kawa");
        table.put(JavaSourceType.UNDEFINED, new JavaSourceStyleEntry(new RGB(255, 97, 0)));
        table.put(JavaSourceType.CODE, new JavaSourceStyleEntry(RGB.BLACK));
        table.put(JavaSourceType.KEYWORD, new JavaSourceStyleEntry(new RGB(0, 0, 192), true, false));
        table.put(JavaSourceType.CODE_TYPE, new JavaSourceStyleEntry(new RGB(192, 0, 0), true, false));
        table.put(JavaSourceType.STRING, new JavaSourceStyleEntry(new RGB(153, 0, 0)));
        table.put(JavaSourceType.COMMENT_LINE, new JavaSourceStyleEntry(new RGB(0, 128, 0)));
        table.put(JavaSourceType.COMMENT_BLOCK, new JavaSourceStyleEntry(new RGB(0, 128, 0)));
        table.put(JavaSourceType.JAVADOC, new JavaSourceStyleEntry(new RGB(0, 128, 0)));
        table.put(JavaSourceType.JAVADOC_KEYWORD, new JavaSourceStyleEntry(new RGB(0, 85, 0)));
        table.put(JavaSourceType.BACKGROUND, new JavaSourceStyleEntry(new RGB(255, 255, 255)));
        table.put(JavaSourceType.NUM_CONSTANT, new JavaSourceStyleEntry(new RGB(153, 0, 0)));
        table.put(JavaSourceType.CHAR_CONSTANT, new JavaSourceStyleEntry(new RGB(153, 0, 0)));
        table.put(JavaSourceType.PARENTHESIS, new JavaSourceStyleEntry(RGB.BLACK));
        table.put(JavaSourceType.JAVADOC_HTML_TAG, new JavaSourceStyleEntry(new RGB(0, 128, 0)));
        table.put(JavaSourceType.JAVADOC_LINKS, new JavaSourceStyleEntry(new RGB(0, 128, 0)));
        table.put(JavaSourceType.LINE_NUMBERS, new JavaSourceStyleEntry(new RGB(128, 128, 128)));
        return table;
    }

    private static JavaSourceStyleTable createDefaultEclipseStyleTable() {
        JavaSourceStyleTable table = new JavaSourceStyleTable("Eclipse");
        table.put(JavaSourceType.CODE, new JavaSourceStyleEntry(RGB.BLACK));
        table.put(JavaSourceType.KEYWORD, new JavaSourceStyleEntry(new RGB(127, 0, 85), true, false));
        table.put(JavaSourceType.CODE_TYPE, new JavaSourceStyleEntry(new RGB(127, 0, 85), true, false));
        table.put(JavaSourceType.STRING, new JavaSourceStyleEntry(new RGB(42, 0, 255)));
        table.put(JavaSourceType.COMMENT_LINE, new JavaSourceStyleEntry(new RGB(63, 127, 95)));
        table.put(JavaSourceType.COMMENT_BLOCK, new JavaSourceStyleEntry(new RGB(63, 127, 95)));
        table.put(JavaSourceType.JAVADOC, new JavaSourceStyleEntry(new RGB(63, 95, 191)));
        table.put(JavaSourceType.JAVADOC_KEYWORD, new JavaSourceStyleEntry(new RGB(127, 159, 191)));
        table.put(JavaSourceType.NUM_CONSTANT, new JavaSourceStyleEntry(new RGB(153, 0, 0)));
        table.put(JavaSourceType.CHAR_CONSTANT, new JavaSourceStyleEntry(new RGB(153, 0, 0)));
        table.put(JavaSourceType.PARENTHESIS, new JavaSourceStyleEntry(new RGB(0, 0, 0)));
        table.put(JavaSourceType.JAVADOC_HTML_TAG, new JavaSourceStyleEntry(new RGB(127, 127, 159)));
        table.put(JavaSourceType.JAVADOC_LINKS, new JavaSourceStyleEntry(new RGB(63, 63, 191)));
        table.put(JavaSourceType.UNDEFINED, new JavaSourceStyleEntry(new RGB(255, 97, 0)));
        table.put(JavaSourceType.BACKGROUND, new JavaSourceStyleEntry(new RGB(255, 255, 255)));
        table.put(JavaSourceType.LINE_NUMBERS, new JavaSourceStyleEntry(new RGB(128, 128, 128)));
        return table;
    }

    private static JavaSourceStyleTable createDefaultMonochromeStyleTable() {
        JavaSourceStyleTable table = new JavaSourceStyleTable("Monochrome");
        table.put(JavaSourceType.CODE, new JavaSourceStyleEntry(RGB.BLACK));
        table.put(JavaSourceType.KEYWORD, new JavaSourceStyleEntry(RGB.BLACK, true, false));
        table.put(JavaSourceType.CODE_TYPE, new JavaSourceStyleEntry(RGB.BLACK, true, false));
        table.put(JavaSourceType.STRING, new JavaSourceStyleEntry(RGB.BLACK));
        table.put(JavaSourceType.COMMENT_LINE, new JavaSourceStyleEntry(RGB.BLACK, false, true));
        table.put(JavaSourceType.COMMENT_BLOCK, new JavaSourceStyleEntry(RGB.BLACK, false, true));
        table.put(JavaSourceType.JAVADOC, new JavaSourceStyleEntry(RGB.BLACK, false, true));
        table.put(JavaSourceType.JAVADOC_KEYWORD, new JavaSourceStyleEntry(RGB.BLACK));
        table.put(JavaSourceType.NUM_CONSTANT, new JavaSourceStyleEntry(RGB.BLACK));
        table.put(JavaSourceType.CHAR_CONSTANT, new JavaSourceStyleEntry(RGB.BLACK));
        table.put(JavaSourceType.PARENTHESIS, new JavaSourceStyleEntry(RGB.BLACK));
        table.put(JavaSourceType.JAVADOC_HTML_TAG, new JavaSourceStyleEntry(RGB.BLACK));
        table.put(JavaSourceType.JAVADOC_LINKS, new JavaSourceStyleEntry(RGB.BLACK));
        table.put(JavaSourceType.UNDEFINED, new JavaSourceStyleEntry(RGB.BLACK));
        table.put(JavaSourceType.BACKGROUND, new JavaSourceStyleEntry(RGB.WHITE));
        table.put(JavaSourceType.LINE_NUMBERS, new JavaSourceStyleEntry(RGB.BLACK));
        return table;
    }

    public void put(JavaSourceType key, JavaSourceStyleEntry javaSourceStyleEntry) {
        this.put(key.getName(), javaSourceStyleEntry);
    }

    public void put(String key, JavaSourceStyleEntry javaSourceStyleEntry) {
        this.table.put(key, javaSourceStyleEntry);
    }

    public static JavaSourceStyleTable getDefault() {
        return JavaSourceStyleTable.createDefaultEclipseStyleTable();
    }

    public static JavaSourceStyleTable getDefaultKawaStyleTable() {
        return JavaSourceStyleTable.createDefaultKawaStyleTable();
    }

    public static JavaSourceStyleTable getDefaultEclipseStyleTable() {
        return JavaSourceStyleTable.createDefaultEclipseStyleTable();
    }

    public static JavaSourceStyleTable getDefaultMonochromeStyleTable() {
        return JavaSourceStyleTable.createDefaultMonochromeStyleTable();
    }

    public JavaSourceStyleEntry get(JavaSourceType key) {
        return this.get(key.getName());
    }

    public JavaSourceStyleEntry get(String key) {
        JavaSourceStyleEntry e = (JavaSourceStyleEntry)this.table.get(key);
        return e == null ? defaultColorEntry : e;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

