/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.converter;

import de.java2html.converter.IJavaSourceConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.options.Java2HtmlConversionOptions;
import de.java2html.options.JavaSourceStyleTable;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public abstract class JavaSourceConverter
implements IJavaSourceConverter {
    protected JavaSource source;
    private Java2HtmlConversionOptions conversionOptions;

    public JavaSourceConverter() {
        this(null);
    }

    public JavaSourceConverter(JavaSource source) {
        this.setSource(source);
        this.setConversionOptions(Java2HtmlConversionOptions.getDefault());
    }

    public void setSource(JavaSource source) {
        this.source = source;
    }

    public abstract String getDefaultFileExtension();

    public abstract void convert(BufferedWriter var1) throws IOException;

    public void convert(Writer writer) throws IOException {
        BufferedWriter bw = null;
        bw = new BufferedWriter(writer);
        this.convert(bw);
        bw.flush();
    }

    public void convert(JavaSource source, Writer writer) throws IOException {
        this.setSource(source);
        this.convert(writer);
    }

    public abstract String getDocumentHeader();

    public abstract String getDocumentFooter();

    public abstract String getBlockSeparator();

    public JavaSourceStyleTable getColorTable() {
        return this.getConversionOptions().getStyleTable();
    }

    public void setConversionOptions(Java2HtmlConversionOptions options) {
        this.conversionOptions = options;
    }

    public Java2HtmlConversionOptions getConversionOptions() {
        return this.conversionOptions;
    }

    public void writeDocumentHeader(Writer writer) throws IOException {
        writer.write(this.getDocumentHeader());
    }

    public void writeDocumentFooter(Writer writer) throws IOException {
        writer.write(this.getDocumentFooter());
    }

    public void writeBlockSeparator(Writer writer) throws IOException {
        writer.write(this.getBlockSeparator());
    }
}

