/*
 * Decompiled with CFR 0.152.
 */
package ch.arrenbrecht.jcite.java;

import ch.arrenbrecht.jcite.FragmentLocator;
import ch.arrenbrecht.jcite.FragmentMarker;
import ch.arrenbrecht.jcite.UnclosedMarkupError;
import ch.arrenbrecht.jcite.java.AbstractJavaCitelet;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MarkerIterator {
    private final AbstractJavaCitelet citelet;

    public MarkerIterator(AbstractJavaCitelet _citelet) {
        this.citelet = _citelet;
    }

    public String iterate(String _fragment, Collection<String> _markerNames) throws UnclosedMarkupError {
        String result = _fragment;
        for (String markerName : _markerNames) {
            StringBuilder builder = new StringBuilder();
            FragmentMarker[] markers = this.citelet.markersFor(markerName);
            FragmentLocator locator = new FragmentLocator();
            int scanFrom = 0;
            while (scanFrom < result.length() && FragmentMarker.findFragment(result, scanFrom, markers, locator)) {
                String prefix = result.substring(scanFrom, locator.beginPrefix);
                String infix = result.substring(locator.beginFragment, locator.endFragment);
                builder.append(prefix);
                this.visit(result, locator, infix, builder);
                scanFrom = locator.endSuffix;
            }
            if (scanFrom <= 0) continue;
            builder.append(result.substring(scanFrom));
            result = builder.toString();
        }
        return result;
    }

    protected abstract void visit(String var1, FragmentLocator var2, String var3, StringBuilder var4);
}

