/*
 * Decompiled with CFR 0.152.
 */
package ch.arrenbrecht.jcite.java;

import de.java2html.converter.JavaSourceConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceType;
import de.java2html.util.HTMLTools;
import java.io.BufferedWriter;
import java.io.IOException;

public class JavaSource2XHtmlFragmentConverter
extends JavaSourceConverter {
    protected static final String TAG_START = "<span class=\"j-";
    protected static final String TAG_END = "\">";
    protected static final String TAG_CLOSE = "</span>";
    protected static final String[] SOURCE_TYPE_NAMES = new String[]{"bkg", "lin", "blk", "cmt", "key", "str", "chr", "num", "sym", "typ", "", "jdoc-key", "jdoc-html", "jdoc-link", "jdoc", "undef"};
    protected boolean pre = true;
    protected String lineEnd = "";
    protected String space = " ";
    protected String sourceCode;
    protected JavaSourceType[] sourceTypes;

    public void setPRE(boolean _pre) {
        this.pre = _pre;
        if (_pre) {
            this.lineEnd = "";
            this.space = " ";
        } else {
            this.lineEnd = "<br />";
            this.space = "&#xA0;";
        }
    }

    public JavaSource2XHtmlFragmentConverter() {
    }

    public JavaSource2XHtmlFragmentConverter(JavaSource source) {
        super(source);
    }

    public String getDocumentHeader() {
        return "";
    }

    public String getDocumentFooter() {
        return "";
    }

    public String getBlockSeparator() {
        return "";
    }

    public String getDefaultFileExtension() {
        return "xhtml";
    }

    public void convert(BufferedWriter writer) throws IOException {
        if (this.source == null) {
            throw new IllegalStateException("Trying to write out converted code without having source set.");
        }
        this.sourceCode = this.source.getCode();
        this.sourceTypes = this.source.getClassification();
        if (this.pre) {
            writer.write("<pre class=\"java\">");
        } else {
            writer.write("<tt class=\"java\">");
        }
        int start = 0;
        int end = 0;
        int length = this.sourceTypes.length;
        while (start < length) {
            while (end < length - 1 && (this.sourceTypes[end + 1] == this.sourceTypes[start] || this.sourceTypes[end + 1] == JavaSourceType.BACKGROUND)) {
                ++end;
            }
            this.toXml(start, end, writer);
            end = start = end + 1;
        }
        if (this.pre) {
            writer.write("</pre>");
        } else {
            writer.write("</tt>");
        }
    }

    protected void toXml(int start, int end, BufferedWriter writer) throws IOException {
        String sourceTypeName = SOURCE_TYPE_NAMES[this.sourceTypes[start].getID()];
        if (!sourceTypeName.equals("")) {
            writer.write(TAG_START + sourceTypeName + TAG_END);
        }
        String t = HTMLTools.encode(this.sourceCode, start, end + 1, "\r\n ");
        for (int i = 0; i < t.length(); ++i) {
            char ch = t.charAt(i);
            if (ch == ' ') {
                if (i < t.length() - 1 && t.charAt(i + 1) == ' ') {
                    writer.write(this.space);
                    continue;
                }
                writer.write(" ");
                continue;
            }
            if (ch == '\n') {
                writer.write(this.lineEnd + "\n");
                continue;
            }
            if (ch == '\r') continue;
            writer.write(ch);
        }
        if (!sourceTypeName.equals("")) {
            writer.write(TAG_CLOSE);
        }
    }
}

