/*
 * Decompiled with CFR 0.152.
 */
package ch.arrenbrecht.jcite.java;

import ch.arrenbrecht.jcite.Constants;
import ch.arrenbrecht.jcite.FragmentLocator;
import ch.arrenbrecht.jcite.java.AbstractJavaCitelet;
import ch.arrenbrecht.jcite.java.MarkerIterator;

class HighlightMarkersIterator
extends MarkerIterator {
    public HighlightMarkersIterator(AbstractJavaCitelet _citelet) {
        super(_citelet);
    }

    protected void visit(String _source, FragmentLocator _locator, String _fragment, StringBuilder _result) {
        this.insertSpaceBeforeIfNeeded(_source, _locator, _fragment, _result);
        _result.append(Constants.BEGIN_HIGHLIGHT).append(_fragment).append(Constants.END_HIGHLIGHT);
        this.insertSpaceAfterIfNeeded(_source, _locator, _fragment, _result);
    }

    private final void insertSpaceBeforeIfNeeded(String _source, FragmentLocator _locator, String _fragment, StringBuilder _result) {
        if (_locator.beginPrefix > 0 && _fragment.length() > 0) {
            this.insertSpaceIfNeeded(_source, _fragment, _result, _locator.beginPrefix - 1, 0, "=,;", "=");
        }
    }

    private final void insertSpaceAfterIfNeeded(String _source, FragmentLocator _locator, String _fragment, StringBuilder _result) {
        if (_locator.endSuffix < _source.length() && _fragment.length() > 0) {
            this.insertSpaceIfNeeded(_source, _fragment, _result, _locator.endSuffix, _fragment.length() - 1, "=", "=})]>,;");
        }
    }

    private final void insertSpaceIfNeeded(String _source, String _fragment, StringBuilder _result, int _outsideIndex, int _insideIndex, String _outsidesLikeLetters, String _insidesLikeLetters) {
        char outside = _source.charAt(_outsideIndex);
        char inside = _fragment.charAt(_insideIndex);
        if ((Character.isLetterOrDigit(outside) || _outsidesLikeLetters.indexOf(outside) >= 0) && (Character.isLetterOrDigit(inside) || _insidesLikeLetters.indexOf(inside) >= 0)) {
            _result.append(' ');
        }
    }
}

