/*
 * Decompiled with CFR 0.152.
 */
package ch.arrenbrecht.jcite.java;

import ch.arrenbrecht.jcite.BlockMarker;
import ch.arrenbrecht.jcite.Constants;
import ch.arrenbrecht.jcite.FileNotFoundError;
import ch.arrenbrecht.jcite.FragmentMarker;
import ch.arrenbrecht.jcite.InlineMarker;
import ch.arrenbrecht.jcite.JCite;
import ch.arrenbrecht.jcite.JCiteError;
import ch.arrenbrecht.jcite.JCitelet;
import ch.arrenbrecht.jcite.TextBasedCitelet;
import ch.arrenbrecht.jcite.java.HighlightMarkersIterator;
import ch.arrenbrecht.jcite.java.OmissionsIterator;
import ch.arrenbrecht.jcite.java.StrippedMarkersIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractJavaCitelet
extends TextBasedCitelet {
    static final Pattern stripPattern = AbstractJavaCitelet.newOptionPattern("strip");
    static final Pattern showPattern = AbstractJavaCitelet.newOptionPattern("show");
    static final Pattern omitPattern = AbstractJavaCitelet.newOptionPattern("omit");
    static final Pattern highlightPattern = AbstractJavaCitelet.newOptionPattern("highlight");
    private final OmissionsIterator omissionsIterator = new OmissionsIterator(this);
    private final StrippedMarkersIterator stripMarkersIterator = new StrippedMarkersIterator(this);
    private final HighlightMarkersIterator highlightMarkersIterator = new HighlightMarkersIterator(this);
    static final String BEGIN_HTML_HIGHLIGHT = "<span class=\"j-hl\">";
    static final String END_HTML_HIGHLIGHT = "</span>";

    private static Pattern newOptionPattern(String _optionName) {
        return Pattern.compile(";\\s*" + _optionName + "\\s*([^;]*)");
    }

    public AbstractJavaCitelet(JCite _jcite) {
        super(_jcite);
    }

    @Override
    protected FragmentMarker[] markersFor(String _fragmentName) {
        InlineMarker inlineMarker = new InlineMarker("/* " + _fragmentName + " */");
        InlineMarker compactInlineMarker = new InlineMarker("/*" + _fragmentName + "*/");
        if (null == _fragmentName || 0 == _fragmentName.length()) {
            return new FragmentMarker[]{inlineMarker, compactInlineMarker};
        }
        BlockMarker blockMarker = new BlockMarker("// " + _fragmentName + "\n");
        return new FragmentMarker[]{blockMarker, inlineMarker, compactInlineMarker};
    }

    @Override
    public final String format(JCitelet.Insertion _insertion) throws JCiteError {
        return this.format(_insertion, "<pre>", "</pre>");
    }

    @Override
    protected String format(JCitelet.Insertion _insertion, String _beginTag, String _endTag) throws JCiteError {
        ArrayList<String> strips = new ArrayList<String>();
        ArrayList<String> shows = new ArrayList<String>();
        ArrayList<String> omissions = new ArrayList<String>();
        ArrayList<String> highlights = new ArrayList<String>();
        if (_insertion instanceof JCitelet.AnnotatedCitation) {
            JCitelet.AnnotatedCitation ann = (JCitelet.AnnotatedCitation)_insertion;
            String options = ';' + ann.annotation();
            this.extractOptions(options, stripPattern, strips);
            this.extractOptions(options, showPattern, shows);
            this.extractOptions(options, omitPattern, omissions);
            this.extractOptions(options, highlightPattern, highlights);
        }
        if (!(strips.contains("") || omissions.contains("") || highlights.contains("") || shows.contains(""))) {
            highlights.add("");
        }
        String fragment = _insertion.text();
        fragment = this.stripIndentation(fragment);
        fragment = this.omissionsIterator.iterate(fragment, omissions);
        fragment = this.stripMarkersIterator.iterate(fragment, strips);
        fragment = this.highlightMarkersIterator.iterate(fragment, highlights);
        fragment = this.trimEmptyLines(fragment);
        fragment = this.formatAsHtml(fragment, _beginTag, _endTag);
        fragment = this.replaceHighlightsWithHtml(fragment);
        return fragment;
    }

    private void extractOptions(String _source, Pattern _pattern, Collection<String> _matches) {
        Matcher m = _pattern.matcher(_source);
        while (m.find()) {
            _matches.add(m.group(1));
        }
    }

    @Override
    protected String getSourceForFile(String _className) throws FileNotFoundError, IOException {
        return super.getSourceForFile(_className.replace('.', '/') + ".java");
    }

    private String formatAsHtml(String _fragment, String _beginTag, String _endTag) {
        if (_fragment == null) {
            return null;
        }
        return this.javaToHtml(_fragment, _beginTag, _endTag);
    }

    protected abstract String javaToHtml(String var1, String var2, String var3);

    private String replaceHighlightsWithHtml(String _fragment) {
        String result = _fragment;
        result = result.replace(Constants.BEGIN_HIGHLIGHT, BEGIN_HTML_HIGHLIGHT);
        result = result.replace(Constants.END_HIGHLIGHT, END_HTML_HIGHLIGHT);
        return result;
    }
}

