/*
 * Decompiled with CFR 0.152.
 */
package ch.arrenbrecht.jcite.excel;

import ch.arrenbrecht.describable.DescriptionBuilder;
import ch.arrenbrecht.jcite.JCite;
import ch.arrenbrecht.jcite.JCiteError;
import ch.arrenbrecht.jcite.JCitelet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import jxl.Cell;
import jxl.CellType;
import jxl.ErrorCell;
import jxl.FormulaCell;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.formula.FormulaException;
import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.format.Font;
import jxl.format.UnderlineStyle;
import jxl.read.biff.BiffException;

public class ExcelCitelet
extends JCitelet {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Map<String, Workbook> cache = new WeakHashMap<String, Workbook>();
    static final Pattern[] ENTITY_PATS = new Pattern[]{Pattern.compile("&", 16), Pattern.compile("<", 16), Pattern.compile(">", 16)};
    static final String[] ENTITY_STRS = new String[]{"&amp;", "&lt;", "&gt;"};

    public ExcelCitelet(JCite _jcite) {
        super(_jcite);
    }

    protected String referencePrefix() {
        return "xc";
    }

    protected JCitelet.Citation cite(String _markup) throws JCiteError, IOException {
        String sourceFileName = _markup;
        String[] options = EMPTY_STRING_ARRAY;
        int posOfSemicolon = sourceFileName.indexOf(59);
        if (posOfSemicolon >= 0) {
            options = sourceFileName.substring(posOfSemicolon + 1).split(",");
            sourceFileName = sourceFileName.substring(0, posOfSemicolon);
        }
        String[] ranges = EMPTY_STRING_ARRAY;
        int posOfColon = sourceFileName.indexOf(58);
        if (posOfColon >= 0) {
            ranges = sourceFileName.substring(posOfColon + 1).split(",");
            sourceFileName = sourceFileName.substring(0, posOfColon);
        }
        Workbook workbook = this.getWorkbook(sourceFileName);
        DescriptionBuilder b = new DescriptionBuilder();
        new WorkbookFormatter(workbook, workbook.getSheet(0), ranges, options).convertSheet(b);
        return new JCitelet.Citation(b.toString());
    }

    private Workbook getWorkbook(String _sourceFileName) throws JCiteError, IOException {
        Workbook cached = this.cache.get(_sourceFileName);
        if (null != cached) {
            return cached;
        }
        Workbook loaded = this.loadWorkbook(_sourceFileName);
        this.cache.put(_sourceFileName, loaded);
        return loaded;
    }

    private Workbook loadWorkbook(String _sourceFileName) throws JCiteError, IOException {
        if (this.isVerbose()) {
            System.out.println("  JCite loading " + _sourceFileName);
        }
        File sourceFile = this.findSourceFile(_sourceFileName);
        try {
            WorkbookSettings xlsSettings = new WorkbookSettings();
            xlsSettings.setLocale(Locale.ENGLISH);
            xlsSettings.setExcelDisplayLanguage("EN");
            xlsSettings.setExcelRegionalSettings("EN");
            xlsSettings.setCellValidationDisabled(true);
            xlsSettings.setAutoFilterDisabled(true);
            xlsSettings.setDrawingsDisabled(true);
            xlsSettings.setSuppressWarnings(true);
            xlsSettings.setGCDisabled(true);
            return Workbook.getWorkbook((File)sourceFile, (WorkbookSettings)xlsSettings);
        }
        catch (BiffException e) {
            throw new JCiteError((Exception)((Object)e));
        }
    }

    protected String format(JCitelet.Insertion _insertion) {
        return _insertion.text();
    }

    private final class WorkbookFormatter {
        private final Workbook workbook;
        private final Sheet sheet;
        private final boolean formulasOnly;
        private final Collection<Range> scope = new ArrayList<Range>();
        private final int firstColumnInScope;
        private final int lastColumnInScope;
        private final Map<Cell, String> namedCells = new HashMap<Cell, String>();
        private final Map<Long, String> rangedCellColors = new HashMap<Long, String>();
        private final Map<String, Range[]> namedRanges = new HashMap<String, Range[]>();
        private final Map<String, String> namedRangeColors = new HashMap<String, String>();

        public WorkbookFormatter(Workbook _workbook, Sheet _sheet, String[] _rangeNames, String[] _options) throws JCiteError {
            this.workbook = _workbook;
            this.sheet = _sheet;
            boolean bl = this.formulasOnly = this.contains(_options, "formulas-only") || this.contains(_options, "fo");
            if (_rangeNames != null && _rangeNames.length > 0) {
                this.setupScope(_rangeNames);
                this.firstColumnInScope = this.getFirstColumnInScope();
                this.lastColumnInScope = this.getLastColumnInScope();
            } else {
                this.firstColumnInScope = 0;
                this.lastColumnInScope = this.sheet.getColumns() - 1;
            }
            this.setupNames(_rangeNames);
        }

        private void setupScope(String[] _rangeNames) throws JCiteError {
            for (String rangeSpec : _rangeNames) {
                String rangeName = rangeSpec.endsWith("+") ? rangeSpec.substring(0, rangeSpec.length() - 1) : rangeSpec;
                Range[] rangeDef = this.workbook.findByName(rangeName);
                if (rangeDef == null) {
                    throw new JCiteError("Range " + rangeName + " not found in workbook.");
                }
                for (Range range : rangeDef) {
                    if (null == range) continue;
                    this.scope.add(range);
                }
            }
        }

        private int getFirstColumnInScope() {
            int min = Integer.MAX_VALUE;
            for (Range r : this.scope) {
                int c = r.getTopLeft().getColumn();
                if (c >= min) continue;
                min = c;
            }
            return min;
        }

        private int getLastColumnInScope() {
            int max = 0;
            for (Range r : this.scope) {
                int c = r.getBottomRight().getColumn();
                if (c <= max) continue;
                max = c;
            }
            return max;
        }

        private boolean isInScope(int _row) {
            if (this.scope.size() == 0) {
                return true;
            }
            for (Range r : this.scope) {
                if (r.getTopLeft().getRow() > _row || _row > r.getBottomRight().getRow()) continue;
                return true;
            }
            return false;
        }

        private boolean isInScope(Cell _cell) {
            if (this.scope.size() == 0) {
                return true;
            }
            for (Range r : this.scope) {
                if (!this.contains(r, _cell)) continue;
                return true;
            }
            return false;
        }

        private boolean isInScope(Range _range) {
            if (this.scope.size() == 0) {
                return true;
            }
            for (Range r : this.scope) {
                if (!this.intersects(r, _range)) continue;
                return true;
            }
            return false;
        }

        private boolean intersects(Range a, Range b) {
            return this.lessOrEqual(b.getTopLeft(), a.getBottomRight()) && this.lessOrEqual(a.getTopLeft(), b.getBottomRight());
        }

        private boolean contains(Range r, Cell c) {
            return this.lessOrEqual(r.getTopLeft(), c) && this.lessOrEqual(c, r.getBottomRight());
        }

        private boolean lessOrEqual(Cell a, Cell b) {
            return a.getRow() <= b.getRow() && a.getColumn() <= b.getColumn();
        }

        private void setupNames(String[] _except) {
            Object[] rangeNames = this.workbook.getRangeNames();
            Arrays.sort(rangeNames);
            int nextRangeNo = 1;
            for (Object rangeName : rangeNames) {
                if (((String)rangeName).equals("ERROR") || this.contains(_except, (String)rangeName)) continue;
                Range[] rangeDef = this.workbook.findByName((String)rangeName);
                if (rangeDef.length > 1) {
                    this.setupNamedRange((String)rangeName, rangeDef, nextRangeNo++);
                    continue;
                }
                if (rangeDef.length != 1) continue;
                Range range = rangeDef[0];
                if (range.getTopLeft().equals(range.getBottomRight())) {
                    this.setupNamedCell((String)rangeName, range.getTopLeft());
                    continue;
                }
                this.setupNamedRange((String)rangeName, rangeDef, nextRangeNo++);
            }
        }

        private boolean contains(String[] _strings, String _string) {
            for (String candidate : _strings) {
                if (!candidate.equals(_string)) continue;
                return true;
            }
            return false;
        }

        private void setupNamedCell(String _name, Cell _cell) {
            if (this.isInScope(_cell)) {
                this.namedCells.put(_cell, _name);
            }
        }

        private void setupNamedRange(String _rangeName, Range[] _rangeDef, int _rangeNumber) {
            String rangeColor = "xl-r" + _rangeNumber;
            boolean inScope = false;
            for (Range r : _rangeDef) {
                if (!this.isInScope(r)) continue;
                inScope = true;
                for (int iRow = r.getTopLeft().getRow(); iRow <= r.getBottomRight().getRow(); ++iRow) {
                    for (int iCol = r.getTopLeft().getColumn(); iCol <= r.getBottomRight().getColumn(); ++iCol) {
                        this.rangedCellColors.put(this.cellToLong(iCol, iRow), rangeColor);
                    }
                }
            }
            if (inScope) {
                this.namedRanges.put(_rangeName, _rangeDef);
                this.namedRangeColors.put(_rangeName, rangeColor);
            }
        }

        private Long cellToLong(int _col, int _row) {
            return (long)_row * 1024L + (long)_col;
        }

        private void convertSheet(DescriptionBuilder b) {
            b.appendLine("<table class=\"xl\">");
            b.indent();
            b.appendLine("<thead>");
            b.indent();
            this.convertHeader(b);
            b.outdent();
            b.appendLine("</thead>");
            b.appendLine("<tbody>");
            b.indent();
            for (int iRow = 0; iRow < this.sheet.getRows(); ++iRow) {
                Cell[] row = this.sheet.getRow(iRow);
                if (!this.isInScope(iRow)) continue;
                this.convertRow(b, iRow, row);
            }
            b.outdent();
            b.appendLine("</tbody>");
            b.outdent();
            b.appendLine("</table>");
            this.convertRangeNames(b);
        }

        private void convertHeader(DescriptionBuilder b) {
            b.appendLine("<tr>");
            b.indent();
            b.appendLine("<td/>");
            for (int iCol = this.firstColumnInScope; iCol <= this.lastColumnInScope; ++iCol) {
                b.append("<td>");
                b.append((char)(65 + iCol));
                b.appendLine("</td>");
            }
            b.outdent();
            b.appendLine("</tr>");
        }

        private void convertRow(DescriptionBuilder b, int _iRow, Cell[] _row) {
            b.appendLine("<tr>");
            b.indent();
            b.append("<td class=\"xl-row\">");
            b.append(_iRow + 1);
            b.appendLine("</td>");
            for (int iCol = this.firstColumnInScope; iCol <= this.lastColumnInScope; ++iCol) {
                Cell cell = iCol < _row.length ? _row[iCol] : null;
                this.convertCell(b, _iRow, iCol, cell);
            }
            b.outdent();
            b.appendLine("</tr>");
        }

        private void convertCell(DescriptionBuilder b, int _iRow, int _iCol, Cell _cell) {
            String cellColor;
            StringBuilder clazz = new StringBuilder();
            StringBuilder attribs = new StringBuilder();
            StringBuilder annotations = new StringBuilder();
            String contents = "";
            if (_cell != null && this.isInScope(_cell)) {
                CellFormat cellFormat;
                CellType cellType = _cell.getType();
                if (cellType == CellType.NUMBER || cellType == CellType.NUMBER_FORMULA) {
                    clazz.append(" xl-num");
                } else if (cellType == CellType.DATE || cellType == CellType.DATE_FORMULA) {
                    clazz.append(" xl-date");
                }
                if (_cell instanceof FormulaCell) {
                    String formula;
                    FormulaCell formulaCell = (FormulaCell)_cell;
                    try {
                        formula = this.htmlize(formulaCell.getFormula());
                    }
                    catch (FormulaException e) {
                        formula = "FORMULA ERROR: " + this.htmlize(e.getMessage());
                    }
                    if (this.formulasOnly) {
                        contents = "<span class=\"xl-exp-only\">=" + formula + "</span>";
                    } else {
                        contents = this.convertValue(_cell);
                        annotations.append("<br/><span class=\"xl-exp\">=").append(formula).append("</span>");
                    }
                } else {
                    contents = this.convertValue(_cell);
                }
                String cellName = this.namedCells.get(_cell);
                if (cellName != null) {
                    annotations.append("<br/><span class=\"xl-name\">(").append(cellName).append(")</span>");
                }
                if ((cellFormat = _cell.getCellFormat()) != null) {
                    Font font;
                    Alignment cellAlignment = cellFormat.getAlignment();
                    if (cellAlignment == Alignment.LEFT) {
                        attribs.append(" style=\"text-align: left\"");
                    }
                    if (cellAlignment == Alignment.RIGHT) {
                        attribs.append(" style=\"text-align: right\"");
                    }
                    if (cellAlignment == Alignment.CENTRE) {
                        attribs.append(" style=\"text-align: center\"");
                    }
                    if (cellAlignment == Alignment.JUSTIFY) {
                        attribs.append(" style=\"text-align: justify\"");
                    }
                    if ((font = cellFormat.getFont()) != null) {
                        if (font.getUnderlineStyle() == UnderlineStyle.SINGLE) {
                            contents = "<span style=\"text-decoration: underline;\">" + contents + "</span>";
                        }
                        if (font.getBoldWeight() > 400) {
                            contents = "<b>" + contents + "</b>";
                        }
                    }
                }
            }
            if ((cellColor = this.rangedCellColors.get(this.cellToLong(_iCol, _iRow))) != null) {
                clazz.append(' ').append(cellColor);
            }
            if (clazz.length() > 0) {
                attribs.append(" class=\"").append(clazz.substring(1)).append("\"");
            }
            b.append("<td");
            b.append(attribs);
            b.append(">");
            b.append(contents);
            b.append(annotations);
            b.appendLine("</td>");
        }

        private String convertValue(Cell _cell) {
            if (_cell instanceof ErrorCell) {
                return this.htmlize(this.convertError((ErrorCell)_cell));
            }
            return this.htmlize(_cell.getContents());
        }

        private String convertError(ErrorCell _cell) {
            int errorCode = _cell.getErrorCode();
            switch (errorCode) {
                case 7: {
                    return "#DIV/0!";
                }
                case 15: {
                    return "#VALUE!";
                }
                case 36: {
                    return "#NUM!";
                }
                case 42: {
                    return "#N/A";
                }
            }
            return "#ERROR:" + errorCode;
        }

        private void convertRangeNames(DescriptionBuilder b) {
            TreeSet<String> rangeNames = new TreeSet<String>();
            rangeNames.addAll(this.namedRanges.keySet());
            for (String rangeName : rangeNames) {
                String rangeColor = this.namedRangeColors.get(rangeName);
                Range[] rangeDef = this.namedRanges.get(rangeName);
                b.append("<br/><span class=\"");
                b.append(rangeColor);
                b.append("\">");
                boolean first = true;
                for (Range r : rangeDef) {
                    if (!first) {
                        b.append(' ');
                        first = false;
                    }
                    b.append((char)(65 + r.getTopLeft().getColumn()));
                    b.append(r.getTopLeft().getRow() + 1);
                    b.append(':');
                    b.append((char)(65 + r.getBottomRight().getColumn()));
                    b.append(r.getBottomRight().getRow() + 1);
                }
                b.append("</span> <span class=\"xl-name\">(");
                b.append(rangeName);
                b.append(")</span>");
            }
        }

        private String htmlize(String _text) {
            String res = _text;
            for (int i = 0; i < ENTITY_PATS.length; ++i) {
                res = ENTITY_PATS[i].matcher(res).replaceAll(ENTITY_STRS[i]);
            }
            return res;
        }
    }
}

