/*
 * Decompiled with CFR 0.152.
 */
package ch.arrenbrecht.jcite;

import ch.arrenbrecht.jcite.JCiteError;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.regex.Pattern;

public class Util {
    public static int scanForwardTo(String _in, char _scanTo, int _startingAt) {
        int result;
        for (result = _startingAt; result < _in.length() && _in.charAt(result) != _scanTo; ++result) {
        }
        return result;
    }

    public static int scanBackTo(String _in, char _scanTo, int _startingAt) {
        int result;
        for (result = _startingAt; result >= 0 && _in.charAt(result) != _scanTo; --result) {
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringFrom(File _source) throws IOException {
        StringBuffer sb = new StringBuffer(1024);
        BufferedReader reader = new BufferedReader(new FileReader(_source));
        try {
            int red;
            char[] chars = new char[1024];
            while ((red = reader.read(chars)) > -1) {
                sb.append(chars, 0, red);
            }
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringTo(String _value, File _target) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(_target));
        try {
            if (null != _value) {
                writer.write(_value);
            }
        }
        finally {
            writer.close();
        }
    }

    public static int execAndPipeOutputToSystem(String ... _args) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(_args);
        Process p = pb.start();
        int result = p.waitFor();
        Util.printStream(p.getInputStream(), System.out);
        Util.printStream(p.getErrorStream(), System.err);
        return result;
    }

    public static void printStream(InputStream _from, PrintStream _printTo) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(new BufferedInputStream(_from)));
        while (((Reader)in).ready()) {
            _printTo.write(((Reader)in).read());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File _src, File _tgt) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(_src));
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(_tgt));
            try {
                while (((InputStream)in).available() > 0) {
                    ((OutputStream)out).write(((InputStream)in).read());
                }
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            ((InputStream)in).close();
        }
    }

    static void iterateFiles(File _inputFolder, String _pattern, File _outputFolder, boolean _recurse, FileVisitor _visitor) throws IOException, JCiteError {
        File[] inputFiles;
        StringBuilder src = new StringBuilder();
        block4: for (int i = 0; i < _pattern.length(); ++i) {
            char c = _pattern.charAt(i);
            switch (c) {
                case '*': {
                    src.append(".*");
                    continue block4;
                }
                case '?': {
                    src.append(".");
                    continue block4;
                }
                default: {
                    src.append("\\x");
                    src.append(Integer.toHexString(c));
                }
            }
        }
        final Pattern pattern = Pattern.compile(src.toString());
        for (File inputFile : inputFiles = _inputFolder.listFiles(new FilenameFilter(){

            public boolean accept(File _dir, String _name) {
                return pattern.matcher(_name).matches();
            }
        })) {
            if (!inputFile.isFile()) continue;
            File outputFile = new File(_outputFolder, inputFile.getName());
            _visitor.visit(inputFile, outputFile);
        }
        if (_recurse) {
            for (File dirOrFile : _inputFolder.listFiles()) {
                if (!dirOrFile.isDirectory() || dirOrFile.getName().equals(".") || dirOrFile.getName().equals("..")) continue;
                File subInputFolder = dirOrFile;
                File subOutputFolder = new File(_outputFolder, subInputFolder.getName());
                Util.iterateFiles(subInputFolder, _pattern, subOutputFolder, _recurse, _visitor);
            }
        }
    }

    public static final String escapeHTMLinPRE(String s) {
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        block44: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block44;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block44;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block44;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block44;
                }
                case '\u00e0': {
                    sb.append("&agrave;");
                    continue block44;
                }
                case '\u00c0': {
                    sb.append("&Agrave;");
                    continue block44;
                }
                case '\u00e2': {
                    sb.append("&acirc;");
                    continue block44;
                }
                case '\u00c2': {
                    sb.append("&Acirc;");
                    continue block44;
                }
                case '\u00e4': {
                    sb.append("&auml;");
                    continue block44;
                }
                case '\u00c4': {
                    sb.append("&Auml;");
                    continue block44;
                }
                case '\u00e5': {
                    sb.append("&aring;");
                    continue block44;
                }
                case '\u00c5': {
                    sb.append("&Aring;");
                    continue block44;
                }
                case '\u00e6': {
                    sb.append("&aelig;");
                    continue block44;
                }
                case '\u00c6': {
                    sb.append("&AElig;");
                    continue block44;
                }
                case '\u00e7': {
                    sb.append("&ccedil;");
                    continue block44;
                }
                case '\u00c7': {
                    sb.append("&Ccedil;");
                    continue block44;
                }
                case '\u00e9': {
                    sb.append("&eacute;");
                    continue block44;
                }
                case '\u00c9': {
                    sb.append("&Eacute;");
                    continue block44;
                }
                case '\u00e8': {
                    sb.append("&egrave;");
                    continue block44;
                }
                case '\u00c8': {
                    sb.append("&Egrave;");
                    continue block44;
                }
                case '\u00ea': {
                    sb.append("&ecirc;");
                    continue block44;
                }
                case '\u00ca': {
                    sb.append("&Ecirc;");
                    continue block44;
                }
                case '\u00eb': {
                    sb.append("&euml;");
                    continue block44;
                }
                case '\u00cb': {
                    sb.append("&Euml;");
                    continue block44;
                }
                case '\u00ef': {
                    sb.append("&iuml;");
                    continue block44;
                }
                case '\u00cf': {
                    sb.append("&Iuml;");
                    continue block44;
                }
                case '\u00f4': {
                    sb.append("&ocirc;");
                    continue block44;
                }
                case '\u00d4': {
                    sb.append("&Ocirc;");
                    continue block44;
                }
                case '\u00f6': {
                    sb.append("&ouml;");
                    continue block44;
                }
                case '\u00d6': {
                    sb.append("&Ouml;");
                    continue block44;
                }
                case '\u00f8': {
                    sb.append("&oslash;");
                    continue block44;
                }
                case '\u00d8': {
                    sb.append("&Oslash;");
                    continue block44;
                }
                case '\u00df': {
                    sb.append("&szlig;");
                    continue block44;
                }
                case '\u00f9': {
                    sb.append("&ugrave;");
                    continue block44;
                }
                case '\u00d9': {
                    sb.append("&Ugrave;");
                    continue block44;
                }
                case '\u00fb': {
                    sb.append("&ucirc;");
                    continue block44;
                }
                case '\u00db': {
                    sb.append("&Ucirc;");
                    continue block44;
                }
                case '\u00fc': {
                    sb.append("&uuml;");
                    continue block44;
                }
                case '\u00dc': {
                    sb.append("&Uuml;");
                    continue block44;
                }
                case '\u00ae': {
                    sb.append("&reg;");
                    continue block44;
                }
                case '\u00a9': {
                    sb.append("&copy;");
                    continue block44;
                }
                case '\u20ac': {
                    sb.append("&euro;");
                    continue block44;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static interface FileVisitor {
        public void visit(File var1, File var2) throws IOException, JCiteError;
    }
}

