/*
 * Decompiled with CFR 0.152.
 */
package ch.arrenbrecht.jcite;

import ch.arrenbrecht.jcite.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;

final class TripwireDatabase {
    private final File path;
    private final boolean saveAsFolder;
    private final String newLine;
    private final SortedMap<String, String> wires = new TreeMap<String, String>();
    private final SortedMap<String, String> wiresAsLoaded = new TreeMap<String, String>();
    static final String ENTRY_SEP = "___@_@___";
    static final String VALUE_SEP = "__@@__";
    private static final char[] ILLEGAL_CHARS = "\\/:,<>'\"\t\n\f\r".toCharArray();

    public TripwireDatabase(File _path, boolean _isFolder) {
        this(_path, _isFolder, null);
    }

    public TripwireDatabase(File _path, boolean _isFolder, String _newLineInDatabase) {
        this.path = _path;
        this.saveAsFolder = _isFolder;
        this.newLine = null == _newLineInDatabase ? System.getProperty("line.separator") : _newLineInDatabase;
    }

    public void load() throws IOException {
        if (this.saveAsFolder) {
            this.loadFromFolder();
        } else {
            this.loadFromFile();
        }
    }

    public void save() throws IOException {
        if (this.saveAsFolder) {
            this.saveToFolder();
        } else {
            this.saveToFile();
        }
    }

    private void loadFromFile() throws IOException {
        if (this.path.exists()) {
            String text = Util.readStringFrom(this.path);
            String[] entries = text.split(ENTRY_SEP);
            String valueSep = VALUE_SEP;
            for (String entry : entries) {
                if (entry.trim().length() <= 0) continue;
                String[] nameAndValue = entry.split(VALUE_SEP);
                this.wiresAsLoaded.put(nameAndValue[0].trim(), nameAndValue[1].trim());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.path));
        try {
            for (Map.Entry<String, String> wire : this.wires.entrySet()) {
                writer.append(wire.getKey());
                writer.append(this.newLine);
                writer.append(VALUE_SEP);
                writer.append(this.newLine);
                writer.append(wire.getValue());
                writer.append(this.newLine);
                writer.append(ENTRY_SEP);
                writer.append(this.newLine);
            }
        }
        finally {
            writer.close();
        }
    }

    private void loadFromFolder() throws IOException {
        File[] files = this.path.listFiles(new TextFileFilter());
        if (null != files) {
            for (File file : files) {
                String text = Util.readStringFrom(file);
                String name = file.getName().substring(0, file.getName().length() - 4);
                this.wiresAsLoaded.put(name, text);
            }
        }
    }

    private void saveToFolder() throws IOException {
        this.path.mkdirs();
        Iterator<Map.Entry<String, String>> hads = this.wiresAsLoaded.entrySet().iterator();
        Map.Entry<String, String> had = hads.hasNext() ? hads.next() : null;
        for (Map.Entry<String, String> have : this.wires.entrySet()) {
            String key = have.getKey();
            String value = have.getValue();
            while (null != had && had.getKey().compareTo(key) < 0) {
                this.fileForWire(had.getKey()).delete();
                had = hads.hasNext() ? hads.next() : null;
            }
            if (null != had && had.getKey().equals(key)) {
                if (!had.getValue().equals(value)) {
                    Util.writeStringTo(value, this.fileForWire(key));
                }
                had = hads.hasNext() ? hads.next() : null;
                continue;
            }
            Util.writeStringTo(value, this.fileForWire(key));
        }
        while (null != had) {
            new File(this.path, had.getKey() + ".txt").delete();
            had = hads.hasNext() ? hads.next() : null;
        }
    }

    private File fileForWire(String _name) {
        return new File(this.path, _name + ".txt");
    }

    public String sanitizeName(String _name) {
        return this.saveAsFolder ? TripwireDatabase.sanitizeNameInFolder(_name) : _name.trim();
    }

    public static String sanitizeNameInFolder(String _name) {
        String result = _name;
        for (char c : ILLEGAL_CHARS) {
            result = result.replace(c, ' ');
        }
        return result.trim();
    }

    public String sanitizeValue(String _value) {
        return _value.trim();
    }

    public boolean check(String _name, String _value) {
        String found = (String)this.wiresAsLoaded.get(_name);
        if (null == found || found.equals(_value)) {
            this.wires.put(_name, _value);
            return true;
        }
        this.wires.put(_name, found);
        return false;
    }

    public void update(String _name, String _value) {
        this.wires.put(_name, _value);
    }

    public String get(String _name) {
        return (String)this.wires.get(_name);
    }

    public String toString() {
        return (this.saveAsFolder ? "folder " : "file ") + this.path.getPath();
    }

    private static final class TextFileFilter
    implements FilenameFilter {
        private static final Pattern NAME_FILTER = Pattern.compile(".*\\.txt", 2);

        private TextFileFilter() {
        }

        public boolean accept(File _dir, String _name) {
            return NAME_FILTER.matcher(_name).matches();
        }
    }
}

