/*
 * Decompiled with CFR 0.152.
 */
package ch.arrenbrecht.jcite;

import ch.arrenbrecht.jcite.Constants;
import ch.arrenbrecht.jcite.FileNotFoundError;
import ch.arrenbrecht.jcite.FragmentLocator;
import ch.arrenbrecht.jcite.FragmentMarker;
import ch.arrenbrecht.jcite.FragmentNotFoundError;
import ch.arrenbrecht.jcite.JCite;
import ch.arrenbrecht.jcite.JCiteError;
import ch.arrenbrecht.jcite.JCitelet;
import ch.arrenbrecht.jcite.UnclosedMarkupError;
import ch.arrenbrecht.jcite.Util;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class TextBasedCitelet
extends JCitelet {
    private Map<String, String> sources = new HashMap<String, String>();

    protected TextBasedCitelet(JCite _jcite) {
        super(_jcite);
    }

    public JCitelet.Citation cite(String _reference) throws JCiteError, IOException {
        String fileSource;
        if (this.isVerbose()) {
            System.out.print("  JCite citing ");
            System.out.println(_reference);
        }
        int endFileName = _reference.indexOf(58);
        int endFragmentName = _reference.length();
        if (endFileName < 0) {
            endFileName = endFragmentName;
        } else {
            int posOfSemicolon = _reference.indexOf(59);
            if (posOfSemicolon >= 0) {
                endFragmentName = posOfSemicolon;
            }
        }
        String fileName = _reference.substring(0, endFileName);
        String fragment = fileSource = this.getSourceForFile(fileName);
        if (endFileName < endFragmentName) {
            String fragmentName = _reference.substring(endFileName + 1, endFragmentName);
            fragment = this.getFragmentFrom(fileSource, fragmentName);
        }
        String instructions = "";
        if (endFragmentName < _reference.length()) {
            instructions = _reference.substring(endFragmentName + 1).trim();
        }
        return instructions.length() > 0 ? new JCitelet.AnnotatedCitation(fragment, instructions) : new JCitelet.Citation(fragment);
    }

    protected JCitelet.Inlined inline(String _citation) {
        if (this.isVerbose()) {
            System.out.print("  JCite citing inline element ");
            System.out.println(_citation);
        }
        return super.inline(_citation);
    }

    protected String getSourceForFile(String _fileName) throws FileNotFoundError, IOException {
        String cachedSource = this.sources.get(_fileName);
        if (null != cachedSource) {
            return cachedSource;
        }
        File sourceFile = this.findSourceFile(_fileName);
        String newSource = this.normalizeLineEndings(Util.readStringFrom(sourceFile));
        this.sources.put(_fileName, newSource);
        return newSource;
    }

    private String normalizeLineEndings(String _string) {
        return (_string.replace(Constants.CRLF, "\n").replace('\r', '\n') + '\n').replaceAll("\\x20+\\n", "\n");
    }

    protected String getFragmentFrom(String _sourceText, String _fragmentName) throws FragmentNotFoundError, UnclosedMarkupError {
        FragmentMarker[] markers = this.markersFor(_fragmentName);
        StringBuffer fragments = new StringBuffer();
        FragmentLocator locator = new FragmentLocator();
        int scanFrom = 0;
        boolean found = false;
        while (scanFrom < _sourceText.length() && FragmentMarker.findFragment(_sourceText, scanFrom, markers, locator)) {
            String fragment = _sourceText.substring(locator.beginFragment, locator.endFragment);
            fragments.append(fragment);
            scanFrom = locator.endSuffix;
            found = true;
        }
        if (!found) {
            throw new FragmentNotFoundError(_sourceText, _fragmentName);
        }
        return fragments.toString();
    }

    protected abstract FragmentMarker[] markersFor(String var1);

    protected final String stripIndentation(String _fragment) {
        int iIndents = 0;
        for (char ch : _fragment.toCharArray()) {
            if (ch != ' ' && ch != '\t') break;
            ++iIndents;
        }
        if (iIndents > 0) {
            String indents = _fragment.substring(0, iIndents);
            return _fragment.substring(iIndents).replace("\n" + indents, "\n");
        }
        return _fragment;
    }

    protected final String trimEmptyLines(String _fragment) {
        int iEnd;
        int iStart;
        for (iStart = 0; iStart < _fragment.length() && _fragment.charAt(iStart) == '\n'; ++iStart) {
        }
        for (iEnd = _fragment.length(); iEnd > 0 && _fragment.charAt(iEnd - 1) == '\n'; --iEnd) {
        }
        return _fragment.substring(iStart, iEnd);
    }

    protected final String escapeXML(String _fragment) {
        return _fragment.replace("<", "&lt;").replace(">", "&gt;");
    }
}

