/*
 * Decompiled with CFR 0.152.
 */
package ch.arrenbrecht.jcite;

import ch.arrenbrecht.jcite.FileNotFoundError;
import ch.arrenbrecht.jcite.JCite;
import ch.arrenbrecht.jcite.JCiteError;
import ch.arrenbrecht.jcite.UnclosedMarkupError;
import ch.arrenbrecht.jcite.Util;
import java.io.File;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCitelet {
    private final JCite jcite;
    private static final String PRE_START = "<pre>";
    private static final String PRE_END = "</pre>";

    public JCitelet(JCite _jcite) {
        this.jcite = _jcite;
    }

    public String process(String _source) throws JCiteError {
        return this.processInlines(this.processCitations(_source));
    }

    protected String processCitations(String _source) throws JCiteError {
        return this.processElements(_source, this.referenceStartTag(), this.referenceEndTag(), new ElementVisitor(){

            public Insertion insertionFor(String _markup) throws JCiteError, IOException {
                return JCitelet.this.cite(_markup);
            }

            public String formatInsertion(Insertion _insertion, String _beginTag, String _endTag) throws JCiteError, IOException {
                return JCitelet.this.format(_insertion, _beginTag, _endTag);
            }
        });
    }

    protected String processInlines(String _source) throws JCiteError {
        return this.processElements(_source, this.inlineStartTag(), this.inlineEndTag(), new ElementVisitor(){

            public Insertion insertionFor(String _citation) {
                return JCitelet.this.inline(_citation);
            }

            public String formatInsertion(Insertion _insertion, String _beginTag, String _endTag) throws JCiteError, IOException {
                return JCitelet.this.format(_insertion, _beginTag, _endTag);
            }
        });
    }

    protected final String processElements(String _source, String _markupStartTag, String _markupEndTag, ElementVisitor _visitor) throws JCiteError {
        int markupStartTagLength = _markupStartTag.length();
        int processedUpto = 0;
        int beginMarkup = _source.indexOf(_markupStartTag, processedUpto);
        if (beginMarkup > 0) {
            int endDeletion;
            StringBuilder result = new StringBuilder(_source.length());
            do {
                int endMarkup;
                if ((endMarkup = _source.indexOf(_markupEndTag, beginMarkup)) < 0) {
                    throw new UnclosedMarkupError("Can't find " + _markupEndTag + " after " + beginMarkup);
                }
                String markup = _source.substring(beginMarkup + markupStartTagLength, endMarkup);
                int beginDeletion = Util.scanBackTo(_source, '<', beginMarkup);
                endDeletion = Util.scanForwardTo(_source, '>', endMarkup);
                if (beginDeletion >= PRE_START.length() && _source.substring(beginDeletion - PRE_START.length(), beginDeletion).equals(PRE_START) && _source.substring(endDeletion + 1, endDeletion + 1 + PRE_END.length()).equals(PRE_END)) {
                    beginDeletion -= PRE_START.length();
                    endDeletion += PRE_END.length();
                }
                String beginTag = _source.substring(beginDeletion, beginMarkup);
                String endTag = _source.substring(endMarkup + 1, endDeletion + 1);
                result.append(_source.substring(processedUpto, beginDeletion));
                try {
                    Insertion insertion = _visitor.insertionFor(markup);
                    String formatted = _visitor.formatInsertion(insertion, beginTag, endTag);
                    result.append(formatted);
                    this.jcite.checkTripwires(markup, insertion.text(), beginMarkup);
                    this.jcite.logCitation(markup, beginMarkup);
                }
                catch (JCiteError e) {
                    this.jcite.logCitationError(e, markup, beginMarkup);
                    result.append(_source.substring(beginDeletion, endDeletion + 1));
                }
                catch (IOException e) {
                    this.jcite.logCitationError(e, markup, beginMarkup);
                    result.append(_source.substring(beginDeletion, endDeletion + 1));
                }
            } while ((beginMarkup = _source.indexOf(_markupStartTag, processedUpto = endDeletion + 1)) > 0);
            result.append(_source.substring(processedUpto));
            return result.toString();
        }
        return _source;
    }

    protected boolean argHandled(String _arg) {
        return false;
    }

    protected abstract String referencePrefix();

    protected abstract Citation cite(String var1) throws JCiteError, IOException;

    protected Inlined inline(String _text) {
        return new Inlined(_text);
    }

    protected String format(Insertion _insertion, String _beginTag, String _endTag) throws JCiteError, IOException {
        return this.format(_insertion);
    }

    protected abstract String format(Insertion var1) throws JCiteError, IOException;

    protected String referenceStartTag() {
        return "[" + this.referencePrefix() + ":";
    }

    protected String referenceEndTag() {
        return "]";
    }

    protected String inlineStartTag() {
        return "<pre jcite=\"" + this.referencePrefix() + "\">";
    }

    protected String inlineEndTag() {
        return PRE_END;
    }

    protected final boolean isVerbose() {
        return this.jcite.isVerbose();
    }

    protected final List<String> sourceFolders() {
        return this.jcite.sourceFolders();
    }

    protected File findSourceFile(String _relativeFilePath) throws FileNotFoundError {
        for (String sourcePath : this.sourceFolders()) {
            String fullPath = sourcePath + '/' + _relativeFilePath;
            File file = new File(fullPath);
            if (!file.exists()) continue;
            return file;
        }
        throw new FileNotFoundError("File " + _relativeFilePath + " not found.");
    }

    protected String findSourcePath(String _relativeFilePath) throws FileNotFoundError {
        for (String sourcePath : this.sourceFolders()) {
            String fullPath = sourcePath + '/' + _relativeFilePath;
            File file = new File(fullPath);
            if (!file.exists()) continue;
            return fullPath;
        }
        throw new FileNotFoundError("File " + _relativeFilePath + " not found.");
    }

    protected String stripProjectPathFrom(String _path) {
        String p = this.jcite.getProjectPath();
        if (p != null && p != "" && _path.startsWith(p)) {
            String sep;
            String rel = _path.substring(p.length());
            if (rel.startsWith(sep = File.separator)) {
                return rel.substring(sep.length());
            }
            return rel;
        }
        return _path;
    }

    protected static interface ElementVisitor {
        public Insertion insertionFor(String var1) throws JCiteError, IOException;

        public String formatInsertion(Insertion var1, String var2, String var3) throws JCiteError, IOException;
    }

    public static class AnnotatedCitation
    extends Citation {
        private final String annotation;

        public AnnotatedCitation(String _text, String _annotation) {
            super(_text);
            this.annotation = _annotation;
        }

        public String annotation() {
            return this.annotation;
        }
    }

    public static class Citation
    extends Insertion {
        public Citation(String _text) {
            super(_text);
        }
    }

    public static final class Inlined
    extends Insertion {
        public Inlined(String _source) {
            super(_source);
        }
    }

    public static abstract class Insertion {
        private final String text;

        public Insertion(String _text) {
            this.text = _text;
        }

        public String text() {
            return this.text;
        }
    }
}

